/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.decoration;

import com.teamabnormals.savage_and_ravage.core.SRConfig;
import com.teamabnormals.savage_and_ravage.core.registry.SRCriteriaTriggers;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class BurningBanner
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Integer> TICKS_TILL_REMOVE = SynchedEntityData.m_135353_(BurningBanner.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Optional<BlockPos>> BLOCK_POS = SynchedEntityData.m_135353_(BurningBanner.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    public static final EntityDataAccessor<Optional<UUID>> OFFENDER_UUID = SynchedEntityData.m_135353_(BurningBanner.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final double[] ROTATED_VERTICES = new double[3];
    private AABB burningBox;
    private double burningBoxRotation;

    public BurningBanner(EntityType<? extends BurningBanner> type, Level world) {
        super(type, world);
        this.burningBox = new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.burningBoxRotation = 0.0;
    }

    public BurningBanner(Level world, BlockPos pos, @Nullable Player player) {
        super((EntityType)SREntityTypes.BURNING_BANNER.get(), world);
        this.setBannerPosition(pos);
        if (player != null) {
            this.setOffenderId(player.m_142081_());
        }
        BlockState state = world.m_8055_(pos);
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() - (state.m_60734_() instanceof WallBannerBlock ? 1 : 0), (double)pos.m_123343_() + 0.5);
        this.burningBox = BurningBanner.getBurningBox(state);
        this.burningBoxRotation = BurningBanner.getBurningBoxRotation(state);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_POS, Optional.empty());
        this.f_19804_.m_135372_(OFFENDER_UUID, Optional.empty());
        this.f_19804_.m_135372_(TICKS_TILL_REMOVE, (Object)110);
    }

    public void m_8119_() {
        this.setTicksTillRemove(this.getTicksTillRemove() - 1);
        int ticksRemaining = this.getTicksTillRemove();
        BlockPos bannerPos = this.getBannerPosition();
        if (bannerPos == null || ticksRemaining <= 0) {
            this.m_146870_();
            return;
        }
        if (ticksRemaining > 10 && !(this.f_19853_.m_7702_(bannerPos) instanceof BannerBlockEntity)) {
            this.extinguishFire();
            return;
        }
        if (this.f_19853_.m_5776_()) {
            for (int i = 0; i < 5; ++i) {
                double randomPositionX = this.burningBox.m_82340_(Direction.Axis.X) + (double)this.f_19853_.m_5822_().nextFloat() * this.burningBox.m_82362_();
                double randomPositionY = this.burningBox.m_82340_(Direction.Axis.Y) + (double)this.f_19853_.m_5822_().nextFloat() * this.burningBox.m_82376_();
                double randomPositionZ = this.burningBox.m_82340_(Direction.Axis.Z) + (double)this.f_19853_.m_5822_().nextFloat() * this.burningBox.m_82385_();
                double[] rotatedPosition = BurningBanner.rotate(randomPositionX, randomPositionY, randomPositionZ, this.burningBoxRotation);
                randomPositionX = (double)bannerPos.m_123341_() + rotatedPosition[0];
                randomPositionY = (double)bannerPos.m_123342_() + rotatedPosition[1];
                randomPositionZ = (double)bannerPos.m_123343_() + rotatedPosition[2];
                if (ticksRemaining > 10) {
                    if (this.f_19796_.nextInt(5) == 2) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, randomPositionX, randomPositionY, randomPositionZ, 0.0, 0.0, 0.0);
                    }
                    if (this.f_19796_.nextInt(5) != 3) continue;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, randomPositionX, randomPositionY, randomPositionZ, 0.0, 0.0, 0.0);
                    continue;
                }
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, randomPositionX, randomPositionY, randomPositionZ, 0.0, 0.0, 0.0);
            }
        } else if (this.getTicksTillRemove() > 10) {
            this.m_5496_(this.f_19853_.m_7702_(bannerPos) instanceof BannerBlockEntity ? SoundEvents.f_11936_ : SoundEvents.f_11937_, 2.0f, this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f);
        } else if (this.getTicksTillRemove() == 10) {
            this.m_5496_(SoundEvents.f_11937_, 2.0f, this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f);
            Player offender = this.getOffender();
            if (offender != null && BurningBanner.isOminousBanner((BlockGetter)this.f_19853_, bannerPos) && ((ServerLevel)this.f_19853_).m_8832_(bannerPos) == null) {
                SRCriteriaTriggers.BURN_OMINOUS_BANNER.trigger((ServerPlayer)offender);
                if (((Boolean)SRConfig.COMMON.noBadOmenOnDeath.get()).booleanValue() && !this.f_19853_.m_46469_().m_46207_(GameRules.f_46154_)) {
                    MobEffectInstance effect = offender.m_21124_(MobEffects.f_19594_);
                    if (effect != null) {
                        offender.m_6234_(MobEffects.f_19594_);
                    }
                    offender.m_7292_(new MobEffectInstance(MobEffects.f_19594_, 120000, Mth.m_14045_((int)(effect == null ? 0 : effect.m_19564_() + 1), (int)0, (int)4), false, false, true));
                }
            }
            this.f_19853_.m_7471_(bannerPos, false);
        }
    }

    public void extinguishFire() {
        this.m_5496_(SoundEvents.f_11937_, 0.5f, this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f);
        this.m_146870_();
    }

    public void m_6210_() {
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Size", 0);
        compound.m_128405_("TicksTillRemove", this.getTicksTillRemove());
        if (this.getBannerPosition() != null) {
            compound.m_128365_("BannerPosition", (Tag)NbtUtils.m_129224_((BlockPos)this.getBannerPosition()));
        }
        if (this.getOffenderId() != null) {
            compound.m_128362_("Offender", this.getOffenderId());
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.setTicksTillRemove(compound.m_128451_("TicksTillRemove"));
        if (compound.m_128425_("BannerPosition", 10)) {
            this.setBannerPosition(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BannerPosition")));
        }
        if (compound.m_128403_("Offender")) {
            this.setOffenderId(compound.m_128342_("Offender"));
        }
    }

    public int getTicksTillRemove() {
        return (Integer)this.f_19804_.m_135370_(TICKS_TILL_REMOVE);
    }

    public void setTicksTillRemove(int tickCount) {
        this.f_19804_.m_135381_(TICKS_TILL_REMOVE, (Object)tickCount);
    }

    @Nullable
    public BlockPos getBannerPosition() {
        return ((Optional)this.f_19804_.m_135370_(BLOCK_POS)).orElse(null);
    }

    private void setBannerPosition(@Nullable BlockPos positionIn) {
        this.f_19804_.m_135381_(BLOCK_POS, Optional.ofNullable(positionIn));
    }

    @Nullable
    public UUID getOffenderId() {
        return ((Optional)this.f_19804_.m_135370_(OFFENDER_UUID)).orElse(null);
    }

    public void setOffenderId(@Nullable UUID ownerId) {
        this.f_19804_.m_135381_(OFFENDER_UUID, Optional.ofNullable(ownerId));
    }

    @Nullable
    public Player getOffender() {
        UUID uuid = this.getOffenderId();
        return uuid == null ? null : this.f_19853_.m_46003_(uuid);
    }

    public AABB getBurningBox() {
        return this.burningBox;
    }

    public double getBurningBoxRotation() {
        return this.burningBoxRotation;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static boolean isOminousBanner(BlockGetter world, BlockPos pos) {
        BannerBlockEntity banner;
        if (world.m_7702_(pos) instanceof BannerBlockEntity && (banner = (BannerBlockEntity)Objects.requireNonNull(world.m_7702_(pos))).m_7755_() instanceof TranslatableComponent) {
            return ((TranslatableComponent)banner.m_7755_()).m_131328_().contains("block.minecraft.ominous_banner");
        }
        return false;
    }

    public static AABB getBurningBox(BlockState state) {
        return state.m_61138_((Property)WallBannerBlock.f_57916_) ? new AABB(0.0625, -0.84375, 0.09375, 0.9375, 0.875, 0.25) : new AABB(0.0625, 0.15625, 0.53125, 0.9375, 1.84375, 0.6875);
    }

    public static double getBurningBoxRotation(BlockState state) {
        Direction direction = state.m_61138_((Property)WallBannerBlock.f_57916_) ? (Direction)state.m_61143_((Property)WallBannerBlock.f_57916_) : null;
        return direction != null ? Math.toRadians(direction.m_122435_()) : (double)((float)((double)((Integer)state.m_61143_((Property)BannerBlock.f_49007_)).intValue() / 8.0 * Math.PI));
    }

    public static double[] rotate(double x, double y, double z, double angle) {
        float cos = Mth.m_14089_((float)((float)angle));
        float sin = Mth.m_14031_((float)((float)angle));
        BurningBanner.ROTATED_VERTICES[0] = 0.5 + (x - 0.5) * (double)cos - (z - 0.5) * (double)sin;
        BurningBanner.ROTATED_VERTICES[1] = y;
        BurningBanner.ROTATED_VERTICES[2] = 0.5 + (x - 0.5) * (double)sin + (z - 0.5) * (double)cos;
        return ROTATED_VERTICES;
    }

    public void writeSpawnData(FriendlyByteBuf buf) {
        BlockPos bannerPos = this.getBannerPosition();
        buf.writeBoolean(bannerPos != null);
        if (bannerPos != null) {
            buf.m_130064_(this.getBannerPosition());
        }
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        BlockPos bannerPos;
        BlockPos blockPos = bannerPos = buf.readBoolean() ? buf.m_130135_() : null;
        if (bannerPos != null) {
            BlockState state = this.f_19853_.m_8055_(bannerPos);
            this.burningBox = BurningBanner.getBurningBox(state);
            this.burningBoxRotation = BurningBanner.getBurningBoxRotation(state);
        }
    }
}

