/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import com.google.common.base.Suppliers;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.client.util.forge.CreativeModeTabBuilderImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public final class CreativeModeTabBuilder {
    private final ResourceLocation name;
    private Supplier<ItemStack> icon;
    private BiConsumer<List<ItemStack>, CreativeModeTab> stacksForDisplay;

    private CreativeModeTabBuilder(ResourceLocation name) {
        this.name = name;
        this.icon = () -> ItemStack.f_41583_;
        this.stacksForDisplay = null;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CreativeModeTab buildImpl(ResourceLocation name, Supplier<ItemStack> icon, BiConsumer<List<ItemStack>, CreativeModeTab> stacksForDisplay) {
        void var2_2;
        void var1_1;
        return CreativeModeTabBuilderImpl.buildImpl(name, (Supplier<ItemStack>)var1_1, (BiConsumer<List<ItemStack>, CreativeModeTab>)var2_2);
    }

    public static CreativeModeTabBuilder builder(ResourceLocation name) {
        return new CreativeModeTabBuilder(name);
    }

    public static SortedCreativeModeTab sorted(CreativeModeTab tab) {
        if (SortedCreativeModeTab.class.isAssignableFrom(tab.getClass())) {
            throw new IllegalStateException("Tab is already sorted!");
        }
        return new SortedCreativeModeTab(tab, tab.m_40775_(), tab.m_40783_());
    }

    public CreativeModeTabBuilder setIcon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    public CreativeModeTabBuilder setItems(Consumer<List<ItemStack>> stacksForDisplay) {
        this.stacksForDisplay = (itemStacks, creativeModeTab) -> stacksForDisplay.accept((List<ItemStack>)itemStacks);
        return this;
    }

    public CreativeModeTabBuilder setItems(BiConsumer<List<ItemStack>, CreativeModeTab> stacksForDisplay) {
        this.stacksForDisplay = stacksForDisplay;
        return this;
    }

    public CreativeModeTab build() {
        return CreativeModeTabBuilder.buildImpl(this.name, this.icon, this.stacksForDisplay);
    }

    public static class SortedCreativeModeTab
    extends CreativeModeTab {
        private final CreativeModeTab parent;
        private final List<Supplier<? extends Item>> orderedItems;
        private final Supplier<Map<Item, Integer>> indexedItems;

        private SortedCreativeModeTab(CreativeModeTab parent, int index, String label) {
            super(index, label);
            this.parent = parent;
            this.orderedItems = new ArrayList<Supplier<? extends Item>>();
            this.indexedItems = Suppliers.memoize(this::indexItems);
        }

        private Map<Item, Integer> indexItems() {
            HashMap<Item, Integer> indexMap = new HashMap<Item, Integer>();
            for (int i = 0; i < this.orderedItems.size(); ++i) {
                indexMap.put(this.orderedItems.get(i).get(), i);
            }
            return indexMap;
        }

        private int getIndex(Item item) {
            Map<Item, Integer> indexes = this.indexedItems.get();
            return indexes.containsKey(item) ? indexes.get(item).intValue() : indexes.size();
        }

        public ItemStack m_6976_() {
            return this.parent.m_6976_();
        }

        public void m_6151_(NonNullList<ItemStack> items) {
            super.m_6151_(items);
            items.sort((stack1, stack2) -> {
                int index1 = this.getIndex(stack1.m_41720_());
                int index2 = this.getIndex(stack2.m_41720_());
                if (this.indexedItems.get().containsKey(stack1.m_41720_()) || this.indexedItems.get().containsKey(stack2.m_41720_())) {
                    return Integer.compare(index1, index2);
                }
                return 1 + Registry.f_122827_.m_7981_((Object)stack1.m_41720_()).compareTo(Registry.f_122827_.m_7981_((Object)stack2.m_41720_()));
            });
        }

        public List<Supplier<? extends Item>> getOrderedItems() {
            return this.orderedItems;
        }
    }
}

