/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.client.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class PollinatedSpriteUploader
extends SimplePreparableReloadListener<TextureAtlas.Preparations>
implements AutoCloseable {
    private final TextureAtlas textureAtlas;
    private final String prefix;
    private final Set<ResourceLocation> registeredSprites;
    private final Set<Supplier<Collection<ResourceLocation>>> registeredSpriteSuppliers;
    private int mipmapLevels;

    public PollinatedSpriteUploader(TextureManager textureManager, ResourceLocation textureLocation, String prefix) {
        this.prefix = prefix;
        this.textureAtlas = new TextureAtlas(textureLocation);
        this.registeredSprites = new HashSet<ResourceLocation>();
        this.registeredSpriteSuppliers = new HashSet<Supplier<Collection<ResourceLocation>>>();
        this.mipmapLevels = 0;
        textureManager.m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    public void registerSprite(ResourceLocation location) {
        this.registeredSprites.add(location);
    }

    public void registerSpriteSupplier(Supplier<Collection<ResourceLocation>> supplier) {
        this.registeredSpriteSuppliers.add(supplier);
    }

    private Stream<ResourceLocation> getResourceLocations() {
        HashSet<ResourceLocation> locations = new HashSet<ResourceLocation>(this.registeredSprites);
        this.registeredSpriteSuppliers.stream().map(Supplier::get).forEach(locations::addAll);
        return Collections.unmodifiableSet(locations).stream();
    }

    public TextureAtlasSprite getSprite(ResourceLocation location) {
        return this.textureAtlas.m_118316_(this.resolveLocation(location));
    }

    private ResourceLocation resolveLocation(ResourceLocation location) {
        return new ResourceLocation(location.m_135827_(), this.prefix + "/" + location.m_135815_());
    }

    protected TextureAtlas.Preparations prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("stitching");
        TextureAtlas.Preparations atlastexture$sheetdata = this.textureAtlas.m_118307_(resourceManager, this.getResourceLocations().map(this::resolveLocation), profiler, this.mipmapLevels);
        profiler.m_7238_();
        profiler.m_7241_();
        return atlastexture$sheetdata;
    }

    protected void apply(TextureAtlas.Preparations object, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("upload");
        this.textureAtlas.m_118312_(object);
        profiler.m_7238_();
        profiler.m_7241_();
    }

    @Override
    public void close() {
        this.textureAtlas.m_118329_();
    }

    public int getMipmapLevels() {
        return this.mipmapLevels;
    }

    public void setMipmapLevels(int mipmapLevels) {
        this.mipmapLevels = Math.max(0, mipmapLevels);
    }
}

