/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.math.NumberUtils;

public class ColorArgumentType
implements ArgumentType<Number> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "123", "-123", "0xffffff");
    private static final SimpleCommandExceptionType INVALID_TYPE = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.pollen.color.invalid"));

    public static ColorArgumentType color() {
        return new ColorArgumentType();
    }

    public static int getColor(CommandContext<?> context, String name) {
        return ((Number)context.getArgument(name, Number.class)).intValue();
    }

    public Number parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        if (!NumberUtils.isCreatable((String)input)) {
            throw INVALID_TYPE.create();
        }
        return NumberUtils.createNumber((String)input);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

