/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.command.argument;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.brigadier.BrigadierArgumentSerializers;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class TimeArgumentType
implements ArgumentType<Long> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0t", "12s", "98h", "4d");
    private static final DynamicCommandExceptionType UNKNOWN_UNIT = new DynamicCommandExceptionType(arg -> new TranslatableComponent("argument.pollen.time.unknown_unit", new Object[]{arg}));
    private static final Dynamic2CommandExceptionType TIME_TOO_LOW = new Dynamic2CommandExceptionType((result, min) -> new TranslatableComponent("argument.time.pollen.low", new Object[]{min, result}));
    private static final Dynamic2CommandExceptionType TIME_TOO_HIGH = new Dynamic2CommandExceptionType((result, max) -> new TranslatableComponent("argument.time.pollen.big", new Object[]{max, result}));
    private static final ImmutableMap<String, Pair<Component, LongFunction<Long>>> TIME_UNITS;
    private final long min;
    private final long max;
    private final TimeUnit unit;

    private TimeArgumentType(long min, long max, TimeUnit unit) {
        this.min = min;
        this.max = max;
        this.unit = unit;
    }

    public static TimeArgumentType time() {
        return new TimeArgumentType(Long.MIN_VALUE, Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    public static TimeArgumentType time(long min, long max, TimeUnit unit) {
        return new TimeArgumentType(min, max, unit);
    }

    public static long getTime(CommandContext<?> context, String name) {
        return ((Number)context.getArgument(name, Number.class)).longValue();
    }

    public Long parse(StringReader reader) throws CommandSyntaxException {
        long time = reader.readLong();
        String unit = reader.readUnquotedString();
        if (!TIME_UNITS.containsKey((Object)unit)) {
            throw UNKNOWN_UNIT.createWithContext((ImmutableStringReader)reader, (Object)unit);
        }
        Component unitName = (Component)((Pair)TIME_UNITS.get((Object)unit)).getLeft();
        long nanos = (Long)((LongFunction)((Pair)TIME_UNITS.get((Object)unit)).getRight()).apply(time);
        long localNanos = this.unit.convert(nanos, TimeUnit.NANOSECONDS);
        if (localNanos < this.min) {
            throw TIME_TOO_LOW.createWithContext((ImmutableStringReader)reader, (Object)new TextComponent(this.min + " ").m_7220_(unitName), (Object)new TextComponent(localNanos + " ").m_7220_(unitName));
        }
        if (localNanos > this.max) {
            throw TIME_TOO_HIGH.createWithContext((ImmutableStringReader)reader, (Object)new TextComponent(this.max + " ").m_7220_(unitName), (Object)new TextComponent(localNanos + " ").m_7220_(unitName));
        }
        return nanos;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public long getMinimum() {
        return this.min;
    }

    public long getMaximum() {
        return this.max;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getRemaining());
        while (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            reader.skip();
        }
        TIME_UNITS.keySet().stream().filter(unit -> reader.getRemaining().isEmpty() || unit.startsWith(reader.getRemaining())).forEach(unit -> builder.suggest(builder.getInput().substring(builder.getStart(), builder.getStart() + reader.getCursor()) + unit, (Message)((Pair)TIME_UNITS.get(unit)).getLeft()));
        return builder.buildFuture();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"ns", (Object)Pair.of((Object)new TextComponent("Nanoseconds"), time -> time));
        builder.put((Object)"us", (Object)Pair.of((Object)new TextComponent("Microseconds"), time -> time * 1000L));
        builder.put((Object)"ms", (Object)Pair.of((Object)new TextComponent("Milliseconds"), time -> time * 1000000L));
        builder.put((Object)"s", (Object)Pair.of((Object)new TextComponent("Seconds"), time -> time * 1000000000L));
        builder.put((Object)"m", (Object)Pair.of((Object)new TextComponent("Minutes"), time -> time * 60000000000L));
        builder.put((Object)"h", (Object)Pair.of((Object)new TextComponent("Hours"), time -> time * 3600000000000L));
        builder.put((Object)"d", (Object)Pair.of((Object)new TextComponent("Days"), time -> time * 86400000000000L));
        builder.put((Object)"t", (Object)Pair.of((Object)new TextComponent("Game Ticks"), time -> time * 50000000L));
        TIME_UNITS = builder.build();
    }

    @ApiStatus.Internal
    public static class Serializer
    implements ArgumentSerializer<TimeArgumentType> {
        public void serializeToNetwork(TimeArgumentType argument, FriendlyByteBuf buf) {
            boolean flag = argument.getMinimum() != Long.MIN_VALUE;
            boolean flag1 = argument.getMaximum() != Long.MAX_VALUE;
            buf.writeByte((int)BrigadierArgumentSerializers.m_121688_((boolean)flag, (boolean)flag1));
            if (flag) {
                buf.writeLong(argument.getMinimum());
            }
            if (flag1) {
                buf.writeLong(argument.getMaximum());
            }
            buf.m_130070_(argument.unit.name().toLowerCase(Locale.ROOT));
        }

        public TimeArgumentType deserializeFromNetwork(FriendlyByteBuf buf) {
            byte b0 = buf.readByte();
            long i = BrigadierArgumentSerializers.m_121686_((byte)b0) ? buf.readLong() : Long.MIN_VALUE;
            long j = BrigadierArgumentSerializers.m_121691_((byte)b0) ? buf.readLong() : Long.MAX_VALUE;
            TimeUnit unit = TimeUnit.valueOf(buf.m_130277_().toUpperCase(Locale.ROOT));
            return TimeArgumentType.time(i, j, unit);
        }

        public void serializeToJson(TimeArgumentType argument, JsonObject json) {
            if (argument.getMinimum() != Long.MIN_VALUE) {
                json.addProperty("min", (Number)argument.getMinimum());
            }
            if (argument.getMaximum() != Long.MAX_VALUE) {
                json.addProperty("max", (Number)argument.getMaximum());
            }
            json.addProperty("unit", argument.getUnit().name().toLowerCase(Locale.ROOT));
        }
    }
}

