/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.config.forge;

import gg.moonflower.pollen.api.config.PollinatedConfigBuilder;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.config.PollinatedModConfig;
import gg.moonflower.pollen.api.config.forge.PollinatedConfigBuilderImpl;
import gg.moonflower.pollen.api.config.forge.PollinatedModConfigImpl;
import gg.moonflower.pollen.api.event.events.ConfigEvent;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ConfigManagerImpl {
    private static final Map<String, Map<PollinatedConfigType, PollinatedModConfig>> CONFIGS = new ConcurrentHashMap<String, Map<PollinatedConfigType, PollinatedModConfig>>();
    private static final Set<String> registeredEvents = ConcurrentHashMap.newKeySet();

    public static <T> T register(String modId, PollinatedConfigType type, String fileName, Function<PollinatedConfigBuilder, T> consumer) {
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Pair<T, ForgeConfigSpec> pair = new PollinatedConfigBuilderImpl(new ForgeConfigSpec.Builder()).configure(consumer);
        ModConfig config = new ModConfig(ConfigManagerImpl.convert(type), (IConfigSpec)pair.getRight(), context.getActiveContainer(), fileName);
        context.getActiveContainer().addConfig(config);
        if (registeredEvents.add(modId)) {
            bus.addListener(event -> {
                ModConfig modConfig = event.getConfig();
                ConfigManagerImpl.get(modConfig.getModId(), ConfigManagerImpl.convert(modConfig.getType())).ifPresent(c -> ConfigEvent.LOADING.invoker().configChanged((PollinatedModConfig)c));
            });
            bus.addListener(event -> {
                ModConfig modConfig = event.getConfig();
                ConfigManagerImpl.get(modConfig.getModId(), ConfigManagerImpl.convert(modConfig.getType())).ifPresent(c -> ConfigEvent.RELOADING.invoker().configChanged((PollinatedModConfig)c));
            });
        }
        CONFIGS.computeIfAbsent(modId, __ -> new EnumMap(PollinatedConfigType.class)).put(type, new PollinatedModConfigImpl(config));
        return (T)pair.getLeft();
    }

    public static ModConfig.Type convert(PollinatedConfigType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PollinatedConfigType.COMMON -> ModConfig.Type.COMMON;
            case PollinatedConfigType.CLIENT -> ModConfig.Type.CLIENT;
            case PollinatedConfigType.SERVER -> ModConfig.Type.SERVER;
        };
    }

    public static PollinatedConfigType convert(ModConfig.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ModConfig.Type.COMMON -> PollinatedConfigType.COMMON;
            case ModConfig.Type.CLIENT -> PollinatedConfigType.CLIENT;
            case ModConfig.Type.SERVER -> PollinatedConfigType.SERVER;
        };
    }

    public static Optional<PollinatedModConfig> get(String modId, PollinatedConfigType type) {
        return !CONFIGS.containsKey(modId) ? Optional.empty() : Optional.ofNullable(CONFIGS.get(modId).get((Object)type));
    }
}

