/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.crafting.forge;

import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollenRecipeTypesImpl {
    public static <T extends Recipe<?>> RecipeSerializer<T> createSerializer(BiFunction<ResourceLocation, JsonObject, T> fromJson, BiFunction<ResourceLocation, FriendlyByteBuf, T> fromNetwork, BiConsumer<FriendlyByteBuf, T> toNetwork) {
        return new ForgeRecipeSerializer<T>(fromJson, fromNetwork, toNetwork);
    }

    private static class ForgeRecipeSerializer<T extends Recipe<?>>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final BiFunction<ResourceLocation, JsonObject, T> fromJson;
        private final BiFunction<ResourceLocation, FriendlyByteBuf, T> fromNetwork;
        private final BiConsumer<FriendlyByteBuf, T> toNetwork;

        private ForgeRecipeSerializer(BiFunction<ResourceLocation, JsonObject, T> fromJson, BiFunction<ResourceLocation, FriendlyByteBuf, T> fromNetwork, BiConsumer<FriendlyByteBuf, T> toNetwork) {
            this.fromJson = fromJson;
            this.fromNetwork = fromNetwork;
            this.toNetwork = toNetwork;
        }

        public T m_6729_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return (T)((Recipe)this.fromJson.apply(resourceLocation, jsonObject));
        }

        public T m_8005_(ResourceLocation id, FriendlyByteBuf buf) {
            return (T)((Recipe)this.fromNetwork.apply(id, buf));
        }

        public void m_6178_(FriendlyByteBuf buf, T recipe) {
            this.toNetwork.accept(buf, (FriendlyByteBuf)recipe);
        }
    }
}

