/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen;

import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class BrewingRecipeBuilder {
    private final Potion result;
    private Potion from;
    private Ingredient ingredient;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;

    public BrewingRecipeBuilder(Potion result) {
        this.result = result;
    }

    public static BrewingRecipeBuilder shaped(Potion result) {
        return new BrewingRecipeBuilder(result);
    }

    public BrewingRecipeBuilder requires(Potion from, Ingredient ingredient) {
        this.from = from;
        this.ingredient = ingredient;
        return this;
    }

    public BrewingRecipeBuilder unlockedBy(String string, CriterionTriggerInstance arg) {
        this.advancement.m_138386_(string, arg);
        return this;
    }

    public BrewingRecipeBuilder group(String string) {
        this.group = string;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, Registry.f_122828_.m_7981_((Object)this.result));
    }

    public void save(Consumer<FinishedRecipe> consumer, String string) {
        ResourceLocation key = Registry.f_122828_.m_7981_((Object)this.result);
        if (new ResourceLocation(string).equals((Object)key)) {
            throw new IllegalStateException("Shaped Recipe " + string + " should remove its 'save' argument");
        }
        this.save(consumer, new ResourceLocation(string));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation arg) {
        this.ensureValid(arg);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)arg)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)arg)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(arg, this.result, this.group == null ? "" : this.group, this.from, this.ingredient, this.advancement, new ResourceLocation(arg.m_135827_(), "recipes/brewing/" + arg.m_135815_())));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.from == null) {
            throw new IllegalStateException("No source potion is defined for brewing recipe " + id + "!");
        }
        if (this.ingredient == null || this.ingredient.m_43947_()) {
            throw new IllegalStateException("No ingredient is defined for brewing recipe " + id + "!");
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Potion from;
        private final Ingredient ingredient;
        private final Potion result;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Potion result, String group, Potion from, Ingredient ingredient, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.group = group;
            this.from = from;
            this.ingredient = ingredient;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("from", Registry.f_122828_.m_7981_((Object)this.from).toString());
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", Registry.f_122828_.m_7981_((Object)this.result).toString());
        }

        public RecipeSerializer<?> m_6637_() {
            return PollenRecipeTypes.BREWING.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

