/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class SoundDefinitionBuilder {
    private final String soundId;
    private final List<SoundBuilder> sounds;
    private String subtitle;

    private SoundDefinitionBuilder(String soundId) {
        this.soundId = soundId;
        this.sounds = new ArrayList<SoundBuilder>();
    }

    public JsonObject toJson() {
        Validate.isTrue((!this.sounds.isEmpty() ? 1 : 0) != 0, (String)"At least one sound file must be defined", (Object[])new Object[0]);
        JsonObject json = new JsonObject();
        if (this.subtitle != null) {
            json.addProperty("subtitle", this.subtitle);
        }
        JsonArray soundsJson = new JsonArray();
        this.sounds.forEach(sound -> soundsJson.add(sound.toJson()));
        json.add("sounds", (JsonElement)soundsJson);
        return json;
    }

    public String getSoundId() {
        return this.soundId;
    }

    public List<SoundBuilder> getSounds() {
        return this.sounds;
    }

    @Nullable
    public String getSubtitle() {
        return this.subtitle;
    }

    public SoundDefinitionBuilder addSound(SoundBuilder sound) {
        this.sounds.add(sound);
        return this;
    }

    public SoundDefinitionBuilder subtitle(@Nullable String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public static SoundDefinitionBuilder forSound(Supplier<SoundEvent> sound) {
        return SoundDefinitionBuilder.definition(sound).addSound(SoundDefinitionBuilder.sound(sound));
    }

    public static SoundDefinitionBuilder definition(Supplier<SoundEvent> sound) {
        return new SoundDefinitionBuilder(sound.get().m_11660_().m_135815_());
    }

    public static SoundDefinitionBuilder definition(String sound) {
        return new SoundDefinitionBuilder(sound);
    }

    public static SoundBuilder sound(Supplier<SoundEvent> sound) {
        return new SoundBuilder(new ResourceLocation(sound.get().m_11660_().m_135827_(), sound.get().m_11660_().m_135815_().replaceAll("\\.", "/")));
    }

    public static SoundBuilder sound(ResourceLocation path) {
        return new SoundBuilder(path);
    }

    public static class SoundBuilder {
        private final ResourceLocation path;
        private float volume;
        private float pitch;
        private int weight;
        private SoundType type;
        private boolean preload;
        private boolean stream;
        private int attenuationDistance;

        public SoundBuilder(ResourceLocation path) {
            this.path = path;
            this.volume = 1.0f;
            this.pitch = 1.0f;
            this.weight = 1;
            this.type = SoundType.FILE;
            this.preload = false;
            this.stream = false;
            this.attenuationDistance = 16;
        }

        public JsonElement toJson() {
            Validate.isTrue((this.volume > 0.0f ? 1 : 0) != 0, (String)"Invalid volume", (Object[])new Object[0]);
            Validate.isTrue((this.pitch > 0.0f ? 1 : 0) != 0, (String)"Invalid pitch", (Object[])new Object[0]);
            Validate.isTrue((this.weight > 0 ? 1 : 0) != 0, (String)"Invalid weight", (Object[])new Object[0]);
            if (this.volume == 1.0f && this.pitch == 1.0f && this.weight == 1 && this.type == SoundType.FILE && !this.preload && !this.stream && this.attenuationDistance == 16) {
                return new JsonPrimitive(this.path.toString());
            }
            JsonObject json = new JsonObject();
            json.addProperty("name", this.path.toString());
            if (this.volume != 1.0f) {
                json.addProperty("volume", (Number)Float.valueOf(this.volume));
            }
            if (this.pitch != 1.0f) {
                json.addProperty("pitch", (Number)Float.valueOf(this.pitch));
            }
            if (this.weight != 1) {
                json.addProperty("weight", (Number)this.weight);
            }
            if (this.type != SoundType.FILE) {
                json.addProperty("type", this.type.name().toLowerCase(Locale.ROOT));
            }
            if (this.preload) {
                json.addProperty("preload", Boolean.valueOf(true));
            }
            if (this.stream) {
                json.addProperty("stream", Boolean.valueOf(true));
            }
            if (this.attenuationDistance != 16) {
                json.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            return json;
        }

        public ResourceLocation getPath() {
            return this.path;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }

        public int getWeight() {
            return this.weight;
        }

        public SoundType getType() {
            return this.type;
        }

        public boolean isPreload() {
            return this.preload;
        }

        public boolean isStream() {
            return this.stream;
        }

        public int getAttenuationDistance() {
            return this.attenuationDistance;
        }

        public SoundBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        public SoundBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public SoundBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public SoundBuilder type(SoundType type) {
            this.type = type;
            return this;
        }

        public SoundBuilder preload() {
            this.preload = true;
            return this;
        }

        public SoundBuilder preload(boolean preload) {
            this.preload = preload;
            return this;
        }

        public SoundBuilder stream() {
            this.stream = true;
            return this;
        }

        public SoundBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public SoundBuilder attenuationDistance(int attenuationDistance) {
            this.attenuationDistance = attenuationDistance;
            return this;
        }
    }

    public static enum SoundType {
        FILE,
        EVENT;

    }
}

