/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PollinatedLanguageProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> keys = new TreeMap<String, String>();
    private final DataGenerator generator;
    protected final String domain;
    protected final String locale;

    public PollinatedLanguageProvider(DataGenerator generator, PollinatedModContainer container, String locale) {
        this.generator = generator;
        this.domain = container.getId();
        this.locale = locale;
    }

    protected abstract void registerTranslations();

    public void m_6865_(HashCache cache) {
        this.registerTranslations();
        Path path = this.generator.m_123916_().resolve("assets/" + this.domain + "/lang/" + this.locale + ".json");
        try {
            JsonElement json = GSON.toJsonTree(this.keys);
            DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)json, (Path)path);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save {}", (Object)path, (Object)e);
        }
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get().m_7705_(), name);
    }

    public void addBlock(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get().m_5524_(), name);
    }

    public void addItem(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get().m_20675_(), name);
    }

    public void addEntityType(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get().m_41778_(), name);
    }

    public void addItemStack(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get().m_44704_(), name);
    }

    public void addEnchantment(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get().m_19481_(), name);
    }

    public void addEffect(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void add(String key, String value) {
        if (this.keys.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    public String m_6055_() {
        return "Language: " + this.locale;
    }
}

