/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.api.datagen.provider.SimpleConditionalDataProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class PollinatedRecipeProvider
extends SimpleConditionalDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final Map<Block, BlockFamily> blockFamilies;

    public PollinatedRecipeProvider(DataGenerator generator) {
        this.generator = generator;
        this.blockFamilies = new HashMap<Block, BlockFamily>();
    }

    public void m_6865_(HashCache cache) throws IOException {
        Path path = this.generator.m_123916_();
        HashSet set = new HashSet();
        Consumer<FinishedRecipe> consumer = finishedRecipe -> {
            if (!set.add(finishedRecipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + finishedRecipe.m_6445_());
            }
            try {
                JsonObject json = finishedRecipe.m_125966_();
                this.injectConditions(finishedRecipe.m_6445_(), json);
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)json, (Path)path.resolve("data/" + finishedRecipe.m_6445_().m_135827_() + "/recipes/" + finishedRecipe.m_6445_().m_135815_() + ".json"));
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)e);
            }
            JsonObject jsonObject = finishedRecipe.m_5860_();
            if (jsonObject != null) {
                try {
                    this.injectConditions(finishedRecipe.m_6445_(), jsonObject);
                    DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)jsonObject, (Path)path.resolve("data/" + finishedRecipe.m_6445_().m_135827_() + "/advancements/" + finishedRecipe.m_6448_().m_135815_() + ".json"));
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't save recipe advancement {}", (Object)path, (Object)e);
                }
            }
        };
        this.buildRecipes(consumer);
        this.blockFamilies.values().stream().filter(BlockFamily::m_175956_).forEach(family -> PollinatedRecipeProvider.generateRecipes(consumer, family));
    }

    protected abstract void buildRecipes(Consumer<FinishedRecipe> var1);

    protected BlockFamily.Builder blockFamily(Block block) {
        BlockFamily.Builder builder = new BlockFamily.Builder(block);
        BlockFamily old = this.blockFamilies.put(block, builder.m_175962_());
        if (old != null) {
            throw new IllegalStateException("Duplicate family definition for " + Registry.f_122824_.m_7981_((Object)block));
        }
        return builder;
    }

    public static void oneToOneConversionRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient, @Nullable String group) {
        PollinatedRecipeProvider.oneToOneConversionRecipe(consumer, result, ingredient, group, 1);
    }

    public static void oneToOneConversionRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient, @Nullable String group, int resultAmount) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)result, (int)resultAmount).m_126209_(ingredient).m_142409_(group).m_142284_(PollinatedRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingredient)).m_142700_(consumer, PollinatedRecipeProvider.getConversionRecipeName(result, ingredient));
    }

    public static void oreSmelting(Consumer<FinishedRecipe> consumer, List<ItemLike> ingredients, ItemLike result, float experience, int cookingTime, @Nullable String group) {
        PollinatedRecipeProvider.oreCooking(consumer, RecipeSerializer.f_44091_, ingredients, result, experience, cookingTime, group, "_from_smelting");
    }

    public static void oreBlasting(Consumer<FinishedRecipe> consumer, List<ItemLike> ingredients, ItemLike result, float experience, int cookingTime, @Nullable String group) {
        PollinatedRecipeProvider.oreCooking(consumer, RecipeSerializer.f_44092_, ingredients, result, experience, cookingTime, group, "_from_blasting");
    }

    public static void oreCooking(Consumer<FinishedRecipe> consumer, SimpleCookingSerializer<?> serializer, List<ItemLike> ingredients, ItemLike result, float experience, int cookingTime, @Nullable String group, String from) {
        for (ItemLike itemLike2 : ingredients) {
            ResourceLocation resultName = PollinatedRecipeProvider.getItemName(result);
            SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike2}), (ItemLike)result, (float)experience, (int)cookingTime, serializer).m_142409_(group).m_142284_(PollinatedRecipeProvider.getHasName(itemLike2), (CriterionTriggerInstance)PollinatedRecipeProvider.has(itemLike2)).m_142700_(consumer, new ResourceLocation(resultName.m_135827_(), resultName.m_135815_() + from + "_" + PollinatedRecipeProvider.getItemName(itemLike2).m_135815_()));
        }
    }

    public static void netheriteSmithing(Consumer<FinishedRecipe> consumer, Item ingredient, Item result) {
        ResourceLocation resultName = PollinatedRecipeProvider.getItemName((ItemLike)result);
        UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (Item)result).m_126389_("has_netherite_ingot", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Items.f_42418_)).m_126395_(consumer, new ResourceLocation(resultName.m_135827_(), resultName.m_135815_() + "_smithing"));
    }

    public static void planksFromLog(Consumer<FinishedRecipe> consumer, ItemLike planks, TagKey<Item> log) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)planks, (int)4).m_206419_(log).m_142409_("planks").m_142284_("has_log", (CriterionTriggerInstance)PollinatedRecipeProvider.has(log)).m_176498_(consumer);
    }

    public static void planksFromLogs(Consumer<FinishedRecipe> consumer, ItemLike planks, TagKey<Item> log) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)planks, (int)4).m_206419_(log).m_142409_("planks").m_142284_("has_logs", (CriterionTriggerInstance)PollinatedRecipeProvider.has(log)).m_176498_(consumer);
    }

    public static void woodFromLogs(Consumer<FinishedRecipe> consumer, ItemLike wood, ItemLike logs) {
        ShapedRecipeBuilder.m_126118_((ItemLike)wood, (int)3).m_126127_(Character.valueOf('#'), logs).m_126130_("##").m_126130_("##").m_142409_("bark").m_142284_("has_log", (CriterionTriggerInstance)PollinatedRecipeProvider.has(logs)).m_176498_(consumer);
    }

    public static void woodenBoat(Consumer<FinishedRecipe> consumer, ItemLike boat, ItemLike planks) {
        ShapedRecipeBuilder.m_126116_((ItemLike)boat).m_126127_(Character.valueOf('#'), planks).m_126130_("# #").m_126130_("###").m_142409_("boat").m_142284_("in_water", (CriterionTriggerInstance)PollinatedRecipeProvider.insideOf(Blocks.f_49990_)).m_176498_(consumer);
    }

    public static RecipeBuilder buttonBuilder(ItemLike button, Ingredient ingredient) {
        return ShapelessRecipeBuilder.m_126189_((ItemLike)button).m_126184_(ingredient);
    }

    public static RecipeBuilder doorBuilder(ItemLike door, Ingredient ingredient) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)door, (int)3).m_126124_(Character.valueOf('#'), ingredient).m_126130_("##").m_126130_("##").m_126130_("##");
    }

    public static RecipeBuilder fenceBuilder(ItemLike fence, Ingredient planks) {
        int resultAmount = fence == Blocks.f_50198_ ? 6 : 3;
        Item stick = fence == Blocks.f_50198_ ? Items.f_42691_ : Items.f_42398_;
        return ShapedRecipeBuilder.m_126118_((ItemLike)fence, (int)resultAmount).m_126124_(Character.valueOf('W'), planks).m_126127_(Character.valueOf('#'), (ItemLike)stick).m_126130_("W#W").m_126130_("W#W");
    }

    public static RecipeBuilder fenceGateBuilder(ItemLike fenceGate, Ingredient planks) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)fenceGate).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('W'), planks).m_126130_("#W#").m_126130_("#W#");
    }

    public static void pressurePlate(Consumer<FinishedRecipe> consumer, ItemLike pressurePlate, ItemLike ingredient) {
        PollinatedRecipeProvider.pressurePlateBuilder(pressurePlate, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_142284_(PollinatedRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingredient)).m_176498_(consumer);
    }

    public static RecipeBuilder pressurePlateBuilder(ItemLike pressurePlate, Ingredient ingredient) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)pressurePlate).m_126124_(Character.valueOf('#'), ingredient).m_126130_("##");
    }

    public static void slab(Consumer<FinishedRecipe> consumer, ItemLike slab, ItemLike ingredient) {
        PollinatedRecipeProvider.slabBuilder(slab, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_142284_(PollinatedRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingredient)).m_176498_(consumer);
    }

    public static RecipeBuilder slabBuilder(ItemLike slab, Ingredient ingredient) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)slab, (int)6).m_126124_(Character.valueOf('#'), ingredient).m_126130_("###");
    }

    public static RecipeBuilder stairBuilder(ItemLike stairs, Ingredient ingredient) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)stairs, (int)4).m_126124_(Character.valueOf('#'), ingredient).m_126130_("#  ").m_126130_("## ").m_126130_("###");
    }

    public static RecipeBuilder trapdoorBuilder(ItemLike trapdoor, Ingredient ingredient) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)trapdoor, (int)2).m_126124_(Character.valueOf('#'), ingredient).m_126130_("###").m_126130_("###");
    }

    public static RecipeBuilder signBuilder(ItemLike sign, Ingredient planks) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)sign, (int)3).m_142409_("sign").m_126124_(Character.valueOf('#'), planks).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" X ");
    }

    public static void coloredWoolFromWhiteWoolAndDye(Consumer<FinishedRecipe> consumer, ItemLike wool, ItemLike dye) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)wool).m_126209_(dye).m_126209_((ItemLike)Blocks.f_50041_).m_142409_("wool").m_142284_("has_white_wool", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Blocks.f_50041_)).m_176498_(consumer);
    }

    public static void carpet(Consumer<FinishedRecipe> consumer, ItemLike carpet, ItemLike wool) {
        ShapedRecipeBuilder.m_126118_((ItemLike)carpet, (int)3).m_126127_(Character.valueOf('#'), wool).m_126130_("##").m_142409_("carpet").m_142284_(PollinatedRecipeProvider.getHasName(wool), (CriterionTriggerInstance)PollinatedRecipeProvider.has(wool)).m_176498_(consumer);
    }

    public static void coloredCarpetFromWhiteCarpetAndDye(Consumer<FinishedRecipe> consumer, ItemLike carpet, ItemLike dye) {
        ShapedRecipeBuilder.m_126118_((ItemLike)carpet, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50336_).m_126127_(Character.valueOf('$'), dye).m_126130_("###").m_126130_("#$#").m_126130_("###").m_142409_("carpet").m_142284_("has_white_carpet", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Blocks.f_50336_)).m_142284_(PollinatedRecipeProvider.getHasName(dye), (CriterionTriggerInstance)PollinatedRecipeProvider.has(dye)).m_142700_(consumer, PollinatedRecipeProvider.getConversionRecipeName(carpet, (ItemLike)Blocks.f_50336_));
    }

    public static void bedFromPlanksAndWool(Consumer<FinishedRecipe> consumer, ItemLike bed, ItemLike wool) {
        ShapedRecipeBuilder.m_126116_((ItemLike)bed).m_126127_(Character.valueOf('#'), wool).m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126130_("###").m_126130_("XXX").m_142409_("bed").m_142284_(PollinatedRecipeProvider.getHasName(wool), (CriterionTriggerInstance)PollinatedRecipeProvider.has(wool)).m_176498_(consumer);
    }

    public static void bedFromWhiteBedAndDye(Consumer<FinishedRecipe> consumer, ItemLike bed, ItemLike dye) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)bed).m_126209_((ItemLike)Items.f_42503_).m_126209_(dye).m_142409_("dyed_bed").m_142284_("has_bed", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Items.f_42503_)).m_142700_(consumer, PollinatedRecipeProvider.getConversionRecipeName(bed, (ItemLike)Items.f_42503_));
    }

    public static void banner(Consumer<FinishedRecipe> consumer, ItemLike banner, ItemLike wool) {
        ShapedRecipeBuilder.m_126116_((ItemLike)banner).m_126127_(Character.valueOf('#'), wool).m_126127_(Character.valueOf('|'), (ItemLike)Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" | ").m_142409_("banner").m_142284_(PollinatedRecipeProvider.getHasName(wool), (CriterionTriggerInstance)PollinatedRecipeProvider.has(wool)).m_176498_(consumer);
    }

    public static void stainedGlassFromGlassAndDye(Consumer<FinishedRecipe> consumer, ItemLike stainedGlass, ItemLike dye) {
        ShapedRecipeBuilder.m_126118_((ItemLike)stainedGlass, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50058_).m_126127_(Character.valueOf('X'), dye).m_126130_("###").m_126130_("#X#").m_126130_("###").m_142409_("stained_glass").m_142284_("has_glass", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Blocks.f_50058_)).m_176498_(consumer);
    }

    public static void stainedGlassPaneFromStainedGlass(Consumer<FinishedRecipe> consumer, ItemLike stainedGlassPane, ItemLike stainedGlass) {
        ShapedRecipeBuilder.m_126118_((ItemLike)stainedGlassPane, (int)16).m_126127_(Character.valueOf('#'), stainedGlass).m_126130_("###").m_126130_("###").m_142409_("stained_glass_pane").m_142284_("has_glass", (CriterionTriggerInstance)PollinatedRecipeProvider.has(stainedGlass)).m_176498_(consumer);
    }

    public static void stainedGlassPaneFromGlassPaneAndDye(Consumer<FinishedRecipe> consumer, ItemLike stainedGlassPane, ItemLike dye) {
        ShapedRecipeBuilder.m_126118_((ItemLike)stainedGlassPane, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50185_).m_126127_(Character.valueOf('$'), dye).m_126130_("###").m_126130_("#$#").m_126130_("###").m_142409_("stained_glass_pane").m_142284_("has_glass_pane", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Blocks.f_50185_)).m_142284_(PollinatedRecipeProvider.getHasName(dye), (CriterionTriggerInstance)PollinatedRecipeProvider.has(dye)).m_142700_(consumer, PollinatedRecipeProvider.getConversionRecipeName(stainedGlassPane, (ItemLike)Blocks.f_50185_));
    }

    public static void coloredTerracottaFromTerracottaAndDye(Consumer<FinishedRecipe> consumer, ItemLike terracotta, ItemLike dye) {
        ShapedRecipeBuilder.m_126118_((ItemLike)terracotta, (int)8).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50352_).m_126127_(Character.valueOf('X'), dye).m_126130_("###").m_126130_("#X#").m_126130_("###").m_142409_("stained_terracotta").m_142284_("has_terracotta", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Blocks.f_50352_)).m_176498_(consumer);
    }

    public static void concretePowder(Consumer<FinishedRecipe> consumer, ItemLike concretePowder, ItemLike dye) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)concretePowder, (int)8).m_126209_(dye).m_126211_((ItemLike)Blocks.f_49992_, 4).m_126211_((ItemLike)Blocks.f_49994_, 4).m_142409_("concrete_powder").m_142284_("has_sand", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Blocks.f_49992_)).m_142284_("has_gravel", (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)Blocks.f_49994_)).m_176498_(consumer);
    }

    public static void candle(Consumer<FinishedRecipe> consumer, ItemLike candle, ItemLike dye) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)candle).m_126209_((ItemLike)Blocks.f_152482_).m_126209_(dye).m_142409_("dyed_candle").m_142284_(PollinatedRecipeProvider.getHasName(dye), (CriterionTriggerInstance)PollinatedRecipeProvider.has(dye)).m_176498_(consumer);
    }

    public static void wall(Consumer<FinishedRecipe> consumer, ItemLike wall, ItemLike ingredient) {
        PollinatedRecipeProvider.wallBuilder(wall, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient})).m_142284_(PollinatedRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingredient)).m_176498_(consumer);
    }

    public static RecipeBuilder wallBuilder(ItemLike wall, Ingredient ingredient) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)wall, (int)6).m_126124_(Character.valueOf('#'), ingredient).m_126130_("###").m_126130_("###");
    }

    public static void polished(Consumer<FinishedRecipe> consumer, ItemLike polished, ItemLike stone) {
        PollinatedRecipeProvider.polishedBuilder(polished, Ingredient.m_43929_((ItemLike[])new ItemLike[]{stone})).m_142284_(PollinatedRecipeProvider.getHasName(stone), (CriterionTriggerInstance)PollinatedRecipeProvider.has(stone)).m_176498_(consumer);
    }

    public static RecipeBuilder polishedBuilder(ItemLike polished, Ingredient stone) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)polished, (int)4).m_126124_(Character.valueOf('S'), stone).m_126130_("SS").m_126130_("SS");
    }

    public static void cut(Consumer<FinishedRecipe> consumer, ItemLike cut, ItemLike stone) {
        PollinatedRecipeProvider.cutBuilder(cut, Ingredient.m_43929_((ItemLike[])new ItemLike[]{stone})).m_142284_(PollinatedRecipeProvider.getHasName(stone), (CriterionTriggerInstance)PollinatedRecipeProvider.has(stone)).m_176498_(consumer);
    }

    public static ShapedRecipeBuilder cutBuilder(ItemLike cut, Ingredient stone) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)cut, (int)4).m_126124_(Character.valueOf('#'), stone).m_126130_("##").m_126130_("##");
    }

    public static void chiseled(Consumer<FinishedRecipe> consumer, ItemLike chiseled, ItemLike stone) {
        PollinatedRecipeProvider.chiseledBuilder(chiseled, Ingredient.m_43929_((ItemLike[])new ItemLike[]{stone})).m_142284_(PollinatedRecipeProvider.getHasName(stone), (CriterionTriggerInstance)PollinatedRecipeProvider.has(stone)).m_176498_(consumer);
    }

    public static ShapedRecipeBuilder chiseledBuilder(ItemLike chisled, Ingredient stone) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)chisled).m_126124_(Character.valueOf('#'), stone).m_126130_("#").m_126130_("#");
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient) {
        PollinatedRecipeProvider.stonecutterResultFromBase(consumer, result, ingredient, 1);
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient, int resultAmount) {
        ResourceLocation resultName = PollinatedRecipeProvider.getConversionRecipeName(result, ingredient);
        SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (ItemLike)result, (int)resultAmount).m_142284_(PollinatedRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingredient)).m_142700_(consumer, new ResourceLocation(resultName.m_135827_(), resultName.m_135815_() + "_stonecutting"));
    }

    public static void smeltingResultFromBase(Consumer<FinishedRecipe> consumer, ItemLike result, ItemLike ingredient) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (ItemLike)result, (float)0.1f, (int)200).m_142284_(PollinatedRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingredient)).m_176498_(consumer);
    }

    public static void nineBlockStorageRecipes(Consumer<FinishedRecipe> consumer, ItemLike ingot, ItemLike block) {
        PollinatedRecipeProvider.nineBlockStorageRecipes(consumer, ingot, block, PollinatedRecipeProvider.getSimpleRecipeName(block), null, PollinatedRecipeProvider.getSimpleRecipeName(ingot), null);
    }

    public static void nineBlockStorageRecipesWithCustomPacking(Consumer<FinishedRecipe> consumer, ItemLike ingot, ItemLike block, ResourceLocation blockName, @Nullable String blockGroup) {
        PollinatedRecipeProvider.nineBlockStorageRecipes(consumer, ingot, block, blockName, blockGroup, PollinatedRecipeProvider.getSimpleRecipeName(ingot), null);
    }

    public static void nineBlockStorageRecipesRecipesWithCustomUnpacking(Consumer<FinishedRecipe> consumer, ItemLike ingot, ItemLike block, ResourceLocation ingotName, @Nullable String ingotGroup) {
        PollinatedRecipeProvider.nineBlockStorageRecipes(consumer, ingot, block, PollinatedRecipeProvider.getSimpleRecipeName(block), null, ingotName, ingotGroup);
    }

    public static void nineBlockStorageRecipes(Consumer<FinishedRecipe> consumer, ItemLike ingot, ItemLike block, ResourceLocation blockName, @Nullable String blockGroup, ResourceLocation ingotName, @Nullable String ingotGroup) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)ingot, (int)9).m_126209_(block).m_142409_(ingotGroup).m_142284_(PollinatedRecipeProvider.getHasName(block), (CriterionTriggerInstance)PollinatedRecipeProvider.has(block)).m_142700_(consumer, ingotName);
        ShapedRecipeBuilder.m_126116_((ItemLike)block).m_126127_(Character.valueOf('#'), ingot).m_126130_("###").m_126130_("###").m_126130_("###").m_142409_(blockGroup).m_142284_(PollinatedRecipeProvider.getHasName(ingot), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingot)).m_142700_(consumer, blockName);
    }

    public static void cookRecipes(Consumer<FinishedRecipe> consumer, String from, SimpleCookingSerializer<?> serializer, int cookingTime) {
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42579_, (ItemLike)Items.f_42580_, 0.35f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42581_, (ItemLike)Items.f_42582_, 0.35f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42526_, (ItemLike)Items.f_42530_, 0.35f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_41910_, (ItemLike)Items.f_42576_, 0.1f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42527_, (ItemLike)Items.f_42531_, 0.35f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42658_, (ItemLike)Items.f_42659_, 0.35f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42485_, (ItemLike)Items.f_42486_, 0.35f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42620_, (ItemLike)Items.f_42674_, 0.35f);
        PollinatedRecipeProvider.simpleCookingRecipe(consumer, from, serializer, cookingTime, (ItemLike)Items.f_42697_, (ItemLike)Items.f_42698_, 0.35f);
    }

    public static void simpleCookingRecipe(Consumer<FinishedRecipe> consumer, String from, SimpleCookingSerializer<?> serializer, int cookingTime, ItemLike ingredient, ItemLike result, float experience) {
        ResourceLocation resultName = PollinatedRecipeProvider.getItemName(result);
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (ItemLike)result, (float)experience, (int)cookingTime, serializer).m_142284_(PollinatedRecipeProvider.getHasName(ingredient), (CriterionTriggerInstance)PollinatedRecipeProvider.has(ingredient)).m_142700_(consumer, new ResourceLocation(resultName.m_135827_(), resultName.m_135815_() + "_from_" + from));
    }

    public static void generateRecipes(Consumer<FinishedRecipe> consumer, BlockFamily blockFamily) {
        blockFamily.m_175954_().forEach((variant, block) -> {
            BiFunction biFunction = (BiFunction)RecipeProvider.f_176513_.get(variant);
            Block itemLike = PollinatedRecipeProvider.getBaseBlock(blockFamily, variant);
            if (biFunction != null) {
                RecipeBuilder recipeBuilder = (RecipeBuilder)biFunction.apply(block, itemLike);
                blockFamily.m_175957_().ifPresent(string -> recipeBuilder.m_142409_(string + (String)(variant == BlockFamily.Variant.CUT ? "" : "_" + variant.m_176020_())));
                recipeBuilder.m_142284_(blockFamily.m_175958_().orElseGet(() -> PollinatedRecipeProvider.lambda$generateRecipes$3((ItemLike)itemLike)), (CriterionTriggerInstance)PollinatedRecipeProvider.has((ItemLike)itemLike));
                recipeBuilder.m_176498_(consumer);
            }
            if (variant == BlockFamily.Variant.CRACKED) {
                PollinatedRecipeProvider.smeltingResultFromBase(consumer, (ItemLike)block, (ItemLike)itemLike);
            }
        });
    }

    public static Block getBaseBlock(BlockFamily blockFamily, BlockFamily.Variant variant) {
        if (variant == BlockFamily.Variant.CHISELED) {
            if (!blockFamily.m_175954_().containsKey(BlockFamily.Variant.SLAB)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return blockFamily.m_175952_(BlockFamily.Variant.SLAB);
        }
        return blockFamily.m_175951_();
    }

    public static EnterBlockTrigger.TriggerInstance insideOf(Block block) {
        return new EnterBlockTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, block, StatePropertiesPredicate.f_67658_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(MinMaxBounds.Ints count, ItemLike item) {
        return PollinatedRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_151443_(count).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance has(ItemLike item) {
        return PollinatedRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> itemTag) {
        return PollinatedRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(itemTag).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... itemPredicates) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, itemPredicates);
    }

    public static String getHasName(ItemLike item) {
        return "has_" + PollinatedRecipeProvider.getItemName(item);
    }

    public static ResourceLocation getItemName(ItemLike item) {
        return Registry.f_122827_.m_7981_((Object)item.m_5456_());
    }

    public static ResourceLocation getSimpleRecipeName(ItemLike item) {
        return PollinatedRecipeProvider.getItemName(item);
    }

    public static ResourceLocation getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        ResourceLocation resultName = PollinatedRecipeProvider.getItemName(result);
        return new ResourceLocation(resultName.m_135827_(), resultName.m_135815_() + "_from_" + PollinatedRecipeProvider.getItemName(ingredient).m_135815_());
    }

    public String m_6055_() {
        return "Recipes";
    }

    private static /* synthetic */ String lambda$generateRecipes$3(ItemLike itemLike) {
        return PollinatedRecipeProvider.getHasName(itemLike);
    }
}

