/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.model;

import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.datagen.provider.model.PollinatedModelGenerator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import org.jetbrains.annotations.Nullable;

public abstract class PollinatedBlockModelGenerator
implements PollinatedModelGenerator {
    private final Consumer<BlockStateGenerator> blockStateOutput;
    private final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
    private final Consumer<Item> skippedAutoModelsOutput;

    public PollinatedBlockModelGenerator(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, Consumer<Item> skippedAutoModelsOutput) {
        this.blockStateOutput = blockStateOutput;
        this.modelOutput = modelOutput;
        this.skippedAutoModelsOutput = skippedAutoModelsOutput;
    }

    public Consumer<BlockStateGenerator> getBlockStateOutput() {
        return this.blockStateOutput;
    }

    public BiConsumer<ResourceLocation, Supplier<JsonElement>> getModelOutput() {
        return this.modelOutput;
    }

    public Consumer<Item> getSkippedAutoModelsOutput() {
        return this.skippedAutoModelsOutput;
    }

    protected void skipAutoItemBlock(Block block) {
        this.skippedAutoModelsOutput.accept(block.m_5456_());
    }

    protected void delegateItemModel(Block block, ResourceLocation delegateModelLocation) {
        this.modelOutput.accept(ModelLocationUtils.m_125571_((Item)block.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(delegateModelLocation));
    }

    protected void delegateItemModel(Item item, ResourceLocation delegateModelLocation) {
        this.modelOutput.accept(ModelLocationUtils.m_125571_((Item)item), (Supplier<JsonElement>)new DelegatedModel(delegateModelLocation));
    }

    protected void createSimpleFlatItemModel(Item flatItem) {
        ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)flatItem), TextureMapping.m_125766_((Item)flatItem), this.modelOutput);
    }

    protected void createSimpleFlatItemModel(Block flatBlock) {
        Item item = flatBlock.m_5456_();
        if (item != Items.f_41852_) {
            ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)item), TextureMapping.m_125738_((Block)flatBlock), this.modelOutput);
        }
    }

    protected void createSimpleFlatItemModel(Block flatBlock, String layerZeroTextureSuffix) {
        ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)flatBlock.m_5456_()), TextureMapping.m_125820_((ResourceLocation)TextureMapping.m_125753_((Block)flatBlock, (String)layerZeroTextureSuffix)), this.modelOutput);
    }

    protected static PropertyDispatch createHorizontalFacingDispatch() {
        return PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125329_((Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_());
    }

    protected static PropertyDispatch createHorizontalFacingDispatchAlt() {
        return PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_()).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270));
    }

    protected static PropertyDispatch createTorchHorizontalDispatch() {
        return PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125329_((Comparable)Direction.EAST, Variant.m_125501_()).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270));
    }

    protected static PropertyDispatch createFacingDispatch() {
        return PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61372_).m_125329_((Comparable)Direction.DOWN, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.UP, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R270)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_()).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125329_((Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90));
    }

    protected static MultiVariantGenerator createRotatedVariant(Block block, ResourceLocation modelLocation) {
        return MultiVariantGenerator.m_125259_((Block)block, (Variant[])PollinatedBlockModelGenerator.createRotatedVariants(modelLocation));
    }

    protected static Variant[] createRotatedVariants(ResourceLocation modelLocation) {
        return new Variant[]{Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelLocation), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)};
    }

    protected static MultiVariantGenerator createRotatedVariant(Block block, ResourceLocation normalModelLocation, ResourceLocation mirroredModelLocation) {
        return MultiVariantGenerator.m_125259_((Block)block, (Variant[])new Variant[]{Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)normalModelLocation), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)mirroredModelLocation), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)normalModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)mirroredModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)});
    }

    protected static PropertyDispatch createBooleanModelDispatch(BooleanProperty property, ResourceLocation trueModelLocation, ResourceLocation falseModelLocation) {
        return PropertyDispatch.m_125294_((Property)property).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trueModelLocation)).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)falseModelLocation));
    }

    protected void createRotatedMirroredVariantBlock(Block block) {
        ResourceLocation resourceLocation = TexturedModel.f_125905_.m_125956_(block, this.modelOutput);
        ResourceLocation resourceLocation2 = TexturedModel.f_125906_.m_125956_(block, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createRotatedVariant(block, resourceLocation, resourceLocation2));
    }

    protected void createRotatedVariantBlock(Block block) {
        ResourceLocation resourceLocation = TexturedModel.f_125905_.m_125956_(block, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createRotatedVariant(block, resourceLocation));
    }

    protected static BlockStateGenerator createButton(Block buttonBlock, ResourceLocation unpoweredModelLocation, ResourceLocation poweredModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)buttonBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)unpoweredModelLocation)).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)poweredModelLocation))).m_125271_((PropertyDispatch)PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61376_, (Property)BlockStateProperties.f_61374_).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.NORTH, Variant.m_125501_()).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)));
    }

    protected static PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> configureDoorHalf(PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean> doorProperties, DoubleBlockHalf doorHalf, ResourceLocation doorModelLocation, ResourceLocation doorRightHingeModelLocation) {
        return doorProperties.m_125429_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation)).m_125429_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation)).m_125429_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorRightHingeModelLocation)).m_125429_((Comparable)Direction.EAST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.SOUTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation)).m_125429_((Comparable)Direction.WEST, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.NORTH, (Comparable)doorHalf, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doorModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180));
    }

    protected static BlockStateGenerator createDoor(Block doorBlock, ResourceLocation bottomHalfModelLocation, ResourceLocation bottomHalfRightHingeModelLocation, ResourceLocation topHalfModelLocation, ResourceLocation topHalfRightHingeModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)doorBlock).m_125271_(PollinatedBlockModelGenerator.configureDoorHalf(PollinatedBlockModelGenerator.configureDoorHalf((PropertyDispatch.C4<Direction, DoubleBlockHalf, DoorHingeSide, Boolean>)PropertyDispatch.m_125303_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61401_, (Property)BlockStateProperties.f_61394_, (Property)BlockStateProperties.f_61446_), DoubleBlockHalf.LOWER, bottomHalfModelLocation, bottomHalfRightHingeModelLocation), DoubleBlockHalf.UPPER, topHalfModelLocation, topHalfRightHingeModelLocation));
    }

    protected static BlockStateGenerator createFence(Block fenceBlock, ResourceLocation fencePostModelLocation, ResourceLocation fenceSideModelLocation) {
        return MultiPartGenerator.m_125204_((Block)fenceBlock).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fencePostModelLocation)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModelLocation).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true));
    }

    protected static BlockStateGenerator createWall(Block wallBlock, ResourceLocation postModelLocation, ResourceLocation lowSideModelLocation, ResourceLocation tallSideModelLocation) {
        return MultiPartGenerator.m_125204_((Block)wallBlock).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)postModelLocation)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61379_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)lowSideModelLocation).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)lowSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61380_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)lowSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)lowSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61379_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)tallSideModelLocation).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)tallSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61380_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)tallSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)tallSideModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true));
    }

    protected static BlockStateGenerator createFenceGate(Block fenceGateBlock, ResourceLocation openModelLocation, ResourceLocation closedModelLocation, ResourceLocation wallOpenModelLocation, ResourceLocation wallClosedModelLocation) {
        return MultiVariantGenerator.m_125256_((Block)fenceGateBlock, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125521_, (Object)true)).m_125271_(PollinatedBlockModelGenerator.createHorizontalFacingDispatchAlt()).m_125271_((PropertyDispatch)PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61442_, (Property)BlockStateProperties.f_61446_).m_125350_((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)closedModelLocation)).m_125350_((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallClosedModelLocation)).m_125350_((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation)).m_125350_((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallOpenModelLocation)));
    }

    protected static BlockStateGenerator createStairs(Block stairsBlock, ResourceLocation innerModelLocation, ResourceLocation straightModelLocation, ResourceLocation outerModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)stairsBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61398_).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)straightModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)outerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)innerModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)));
    }

    protected static BlockStateGenerator createOrientableTrapdoor(Block orientableTrapdoorBlock, ResourceLocation topModelLocation, ResourceLocation bottomModelLocation, ResourceLocation openModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)orientableTrapdoorBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61446_).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R0)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)));
    }

    protected static BlockStateGenerator createTrapdoor(Block trapdoorBlock, ResourceLocation topModelLocation, ResourceLocation bottomModelLocation, ResourceLocation openModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)trapdoorBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61446_).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModelLocation)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModelLocation)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)openModelLocation).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)));
    }

    protected static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation modelLocation) {
        return MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelLocation));
    }

    protected static PropertyDispatch createRotatedPillar() {
        return PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125329_((Comparable)Direction.Axis.Y, Variant.m_125501_()).m_125329_((Comparable)Direction.Axis.Z, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.Axis.X, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90));
    }

    protected static BlockStateGenerator createAxisAlignedPillarBlock(Block axisAlignedPillarBlock, ResourceLocation modelLocation) {
        return MultiVariantGenerator.m_125256_((Block)axisAlignedPillarBlock, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelLocation)).m_125271_(PollinatedBlockModelGenerator.createRotatedPillar());
    }

    protected void createAxisAlignedPillarBlockCustomModel(Block axisAlignedPillarBlock, ResourceLocation modelLocation) {
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(axisAlignedPillarBlock, modelLocation));
    }

    protected void createAxisAlignedPillarBlock(Block axisAlignedPillarBlock, TexturedModel.Provider provider) {
        ResourceLocation resourceLocation = provider.m_125956_(axisAlignedPillarBlock, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(axisAlignedPillarBlock, resourceLocation));
    }

    protected void createHorizontallyRotatedBlock(Block horizontallyRotatedBlock, TexturedModel.Provider provider) {
        ResourceLocation resourceLocation = provider.m_125956_(horizontallyRotatedBlock, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)horizontallyRotatedBlock, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation)).m_125271_(PollinatedBlockModelGenerator.createHorizontalFacingDispatch()));
    }

    protected static BlockStateGenerator createRotatedPillarWithHorizontalVariant(Block rotatedPillarBlock, ResourceLocation modelLocation, ResourceLocation horizontalModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)rotatedPillarBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125329_((Comparable)Direction.Axis.Y, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelLocation)).m_125329_((Comparable)Direction.Axis.Z, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.Axis.X, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModelLocation).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)));
    }

    protected void createRotatedPillarWithHorizontalVariant(Block rotatedPillarBlock, TexturedModel.Provider modelProvider, TexturedModel.Provider horizontalModelProvider) {
        ResourceLocation resourceLocation = modelProvider.m_125956_(rotatedPillarBlock, this.modelOutput);
        ResourceLocation resourceLocation2 = horizontalModelProvider.m_125956_(rotatedPillarBlock, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createRotatedPillarWithHorizontalVariant(rotatedPillarBlock, resourceLocation, resourceLocation2));
    }

    protected ResourceLocation createSuffixedVariant(Block block, String suffix, ModelTemplate modelTemplate, Function<ResourceLocation, TextureMapping> textureMappingGetter) {
        return modelTemplate.m_125596_(block, suffix, textureMappingGetter.apply(TextureMapping.m_125753_((Block)block, (String)suffix)), this.modelOutput);
    }

    protected static BlockStateGenerator createPressurePlate(Block pressurePlateBlock, ResourceLocation unpoweredModelLocation, ResourceLocation poweredModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)pressurePlateBlock).m_125271_(PollinatedBlockModelGenerator.createBooleanModelDispatch(BlockStateProperties.f_61448_, poweredModelLocation, unpoweredModelLocation));
    }

    protected static BlockStateGenerator createSlab(Block slabBlock, ResourceLocation bottomHalfModelLocation, ResourceLocation topHalfModelLocation, ResourceLocation doubleModelLocation) {
        return MultiVariantGenerator.m_125254_((Block)slabBlock).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61397_).m_125329_((Comparable)SlabType.BOTTOM, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomHalfModelLocation)).m_125329_((Comparable)SlabType.TOP, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topHalfModelLocation)).m_125329_((Comparable)SlabType.DOUBLE, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)doubleModelLocation)));
    }

    protected void createTrivialCube(Block block) {
        this.createTrivialBlock(block, TexturedModel.f_125905_);
    }

    protected void createTrivialBlock(Block block, TexturedModel.Provider provider) {
        this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(block, provider.m_125956_(block, this.modelOutput)));
    }

    protected void createTrivialBlock(Block block, TextureMapping textureMapping, ModelTemplate modelTemplate) {
        ResourceLocation resourceLocation = modelTemplate.m_125592_(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(block, resourceLocation));
    }

    protected BlockFamilyProvider family(Block block, TexturedModel texturedModel) {
        return new BlockFamilyProvider(texturedModel.m_125951_()).fullBlock(block, texturedModel.m_125932_());
    }

    protected BlockFamilyProvider family(Block block, TexturedModel.Provider provider) {
        TexturedModel texturedModel = provider.m_125964_(block);
        return new BlockFamilyProvider(texturedModel.m_125951_()).fullBlock(block, texturedModel.m_125932_());
    }

    protected BlockFamilyProvider family(Block block) {
        return this.family(block, TexturedModel.f_125905_);
    }

    protected BlockFamilyProvider family(TextureMapping textureMapping) {
        return new BlockFamilyProvider(textureMapping);
    }

    protected void createDoor(Block doorBlock) {
        TextureMapping textureMapping = TextureMapping.m_125832_((Block)doorBlock);
        ResourceLocation resourceLocation = ModelTemplates.f_125704_.m_125592_(doorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation2 = ModelTemplates.f_125705_.m_125592_(doorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation3 = ModelTemplates.f_125706_.m_125592_(doorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation4 = ModelTemplates.f_125707_.m_125592_(doorBlock, textureMapping, this.modelOutput);
        this.createSimpleFlatItemModel(doorBlock.m_5456_());
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createDoor(doorBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
    }

    protected void createOrientableTrapdoor(Block orientableTrapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.m_125768_((Block)orientableTrapdoorBlock);
        ResourceLocation resourceLocation = ModelTemplates.f_125636_.m_125592_(orientableTrapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation2 = ModelTemplates.f_125637_.m_125592_(orientableTrapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation3 = ModelTemplates.f_125638_.m_125592_(orientableTrapdoorBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createOrientableTrapdoor(orientableTrapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.delegateItemModel(orientableTrapdoorBlock, resourceLocation2);
    }

    protected void createTrapdoor(Block trapdoorBlock) {
        TextureMapping textureMapping = TextureMapping.m_125768_((Block)trapdoorBlock);
        ResourceLocation resourceLocation = ModelTemplates.f_125633_.m_125592_(trapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation2 = ModelTemplates.f_125634_.m_125592_(trapdoorBlock, textureMapping, this.modelOutput);
        ResourceLocation resourceLocation3 = ModelTemplates.f_125635_.m_125592_(trapdoorBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept(PollinatedBlockModelGenerator.createTrapdoor(trapdoorBlock, resourceLocation, resourceLocation2, resourceLocation3));
        this.delegateItemModel(trapdoorBlock, resourceLocation2);
    }

    protected WoodProvider woodProvider(Block logBlock) {
        return new WoodProvider(TextureMapping.m_125824_((Block)logBlock));
    }

    protected void createNonTemplateModelBlock(Block block) {
        this.createNonTemplateModelBlock(block, block);
    }

    protected void createNonTemplateModelBlock(Block block, Block modelBlock) {
        this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(block, ModelLocationUtils.m_125576_((Block)modelBlock)));
    }

    protected void createCrossBlockWithDefaultItem(Block crossBlock, BlockModelGenerators.TintState tintState) {
        this.createSimpleFlatItemModel(crossBlock);
        this.createCrossBlock(crossBlock, tintState);
    }

    protected void createCrossBlockWithDefaultItem(Block crossBlock, BlockModelGenerators.TintState tintState, TextureMapping textureMapping) {
        this.createSimpleFlatItemModel(crossBlock);
        this.createCrossBlock(crossBlock, tintState, textureMapping);
    }

    protected void createCrossBlock(Block crossBlock, BlockModelGenerators.TintState tintState) {
        TextureMapping textureMapping = TextureMapping.m_125780_((Block)crossBlock);
        this.createCrossBlock(crossBlock, tintState, textureMapping);
    }

    protected void createCrossBlock(Block crossBlock, BlockModelGenerators.TintState tintState, TextureMapping textureMapping) {
        ResourceLocation resourceLocation = tintState.m_125064_().m_125592_(crossBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(crossBlock, resourceLocation));
    }

    protected void createPlant(Block plantBlock, Block pottedPlantBlock, BlockModelGenerators.TintState tintState) {
        this.createCrossBlockWithDefaultItem(plantBlock, tintState);
        TextureMapping textureMapping = TextureMapping.m_125790_((Block)plantBlock);
        ResourceLocation resourceLocation = tintState.m_125065_().m_125592_(pottedPlantBlock, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(pottedPlantBlock, resourceLocation));
    }

    protected void copyModel(Block sourceBlock, Block targetBlock) {
        ResourceLocation resourceLocation = ModelLocationUtils.m_125576_((Block)sourceBlock);
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)targetBlock, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation)));
        this.delegateItemModel(targetBlock, resourceLocation);
    }

    public class BlockFamilyProvider {
        private final TextureMapping mapping;
        @Nullable
        private ResourceLocation fullBlock;

        private BlockFamilyProvider(TextureMapping textureMapping) {
            this.mapping = textureMapping;
        }

        public BlockFamilyProvider fullBlock(Block block, ModelTemplate modelTemplate) {
            this.fullBlock = modelTemplate.m_125592_(block, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(block, this.fullBlock));
            return this;
        }

        public BlockFamilyProvider fullBlock(Function<TextureMapping, ResourceLocation> function) {
            this.fullBlock = function.apply(this.mapping);
            return this;
        }

        public BlockFamilyProvider button(Block buttonBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125701_.m_125592_(buttonBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125702_.m_125592_(buttonBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createButton(buttonBlock, resourceLocation, resourceLocation2));
            ResourceLocation resourceLocation3 = ModelTemplates.f_125703_.m_125592_(buttonBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.delegateItemModel(buttonBlock, resourceLocation3);
            return this;
        }

        public BlockFamilyProvider wall(Block wallBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125711_.m_125592_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125712_.m_125592_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation3 = ModelTemplates.f_125713_.m_125592_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createWall(wallBlock, resourceLocation, resourceLocation2, resourceLocation3));
            ResourceLocation resourceLocation4 = ModelTemplates.f_125714_.m_125592_(wallBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.delegateItemModel(wallBlock, resourceLocation4);
            return this;
        }

        public BlockFamilyProvider fence(Block fenceBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125708_.m_125592_(fenceBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125709_.m_125592_(fenceBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createFence(fenceBlock, resourceLocation, resourceLocation2));
            ResourceLocation resourceLocation3 = ModelTemplates.f_125710_.m_125592_(fenceBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.delegateItemModel(fenceBlock, resourceLocation3);
            return this;
        }

        public BlockFamilyProvider fenceGate(Block fenceGateBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125621_.m_125592_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125715_.m_125592_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation3 = ModelTemplates.f_125623_.m_125592_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation4 = ModelTemplates.f_125622_.m_125592_(fenceGateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createFenceGate(fenceGateBlock, resourceLocation, resourceLocation2, resourceLocation3, resourceLocation4));
            return this;
        }

        public BlockFamilyProvider pressurePlate(Block pressurePlateBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125624_.m_125592_(pressurePlateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125625_.m_125592_(pressurePlateBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createPressurePlate(pressurePlateBlock, resourceLocation, resourceLocation2));
            return this;
        }

        public BlockFamilyProvider sign(Block block, Block block2) {
            ResourceLocation resourceLocation = ModelTemplates.f_125626_.m_125592_(block, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(block, resourceLocation));
            PollinatedBlockModelGenerator.this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(block2, resourceLocation));
            PollinatedBlockModelGenerator.this.createSimpleFlatItemModel(block.m_5456_());
            PollinatedBlockModelGenerator.this.skipAutoItemBlock(block2);
            return this;
        }

        public BlockFamilyProvider slab(Block slabBlock) {
            if (this.fullBlock == null) {
                throw new IllegalStateException("Full block not generated yet");
            }
            ResourceLocation resourceLocation = ModelTemplates.f_125627_.m_125592_(slabBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125628_.m_125592_(slabBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createSlab(slabBlock, resourceLocation, resourceLocation2, this.fullBlock));
            return this;
        }

        public BlockFamilyProvider stairs(Block stairsBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125631_.m_125592_(stairsBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125630_.m_125592_(stairsBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation3 = ModelTemplates.f_125632_.m_125592_(stairsBlock, this.mapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createStairs(stairsBlock, resourceLocation, resourceLocation2, resourceLocation3));
            return this;
        }
    }

    public class WoodProvider {
        private final TextureMapping logMapping;

        private WoodProvider(TextureMapping textureMapping) {
            this.logMapping = textureMapping;
        }

        public WoodProvider wood(Block woodBlock) {
            TextureMapping textureMapping = this.logMapping.m_125785_(TextureSlot.f_125870_, this.logMapping.m_125756_(TextureSlot.f_125875_));
            ResourceLocation resourceLocation = ModelTemplates.f_125694_.m_125592_(woodBlock, textureMapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(woodBlock, resourceLocation));
            return this;
        }

        public WoodProvider log(Block logBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125694_.m_125592_(logBlock, this.logMapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createAxisAlignedPillarBlock(logBlock, resourceLocation));
            return this;
        }

        public WoodProvider logWithHorizontal(Block logBlock) {
            ResourceLocation resourceLocation = ModelTemplates.f_125694_.m_125592_(logBlock, this.logMapping, PollinatedBlockModelGenerator.this.modelOutput);
            ResourceLocation resourceLocation2 = ModelTemplates.f_125695_.m_125592_(logBlock, this.logMapping, PollinatedBlockModelGenerator.this.modelOutput);
            PollinatedBlockModelGenerator.this.blockStateOutput.accept(PollinatedBlockModelGenerator.createRotatedPillarWithHorizontalVariant(logBlock, resourceLocation, resourceLocation2));
            return this;
        }
    }

    public class BlockEntityModelGenerator {
        private final ResourceLocation baseModel;

        public BlockEntityModelGenerator(ResourceLocation resourceLocation, Block block) {
            this.baseModel = ModelTemplates.f_125626_.m_125612_(resourceLocation, TextureMapping.m_125834_((Block)block), PollinatedBlockModelGenerator.this.modelOutput);
        }

        public BlockEntityModelGenerator create(Block ... blocks) {
            for (Block block : blocks) {
                PollinatedBlockModelGenerator.this.blockStateOutput.accept((BlockStateGenerator)PollinatedBlockModelGenerator.createSimpleBlock(block, this.baseModel));
            }
            return this;
        }

        public BlockEntityModelGenerator createWithoutBlockItem(Block ... blocks) {
            for (Block block : blocks) {
                PollinatedBlockModelGenerator.this.skipAutoItemBlock(block);
            }
            return this.create(blocks);
        }

        public BlockEntityModelGenerator createWithCustomBlockItemModel(ModelTemplate modelTemplate, Block ... blocks) {
            for (Block block : blocks) {
                modelTemplate.m_125612_(ModelLocationUtils.m_125571_((Item)block.m_5456_()), TextureMapping.m_125834_((Block)block), PollinatedBlockModelGenerator.this.modelOutput);
            }
            return this.create(blocks);
        }
    }
}

