/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.datagen.provider.model;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import gg.moonflower.pollen.api.datagen.provider.model.PollinatedModelGenerator;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PollinatedModelProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Set<ModelGeneratorFactory> factories = new HashSet<ModelGeneratorFactory>();
    private final DataGenerator generator;
    private final String domain;

    public PollinatedModelProvider(DataGenerator generator, PollinatedModContainer container) {
        this.generator = generator;
        this.domain = container.getId();
    }

    public PollinatedModelProvider addGenerator(ModelGeneratorFactory factory) {
        this.factories.add(factory);
        return this;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashMap blockStates = new HashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.m_6968_();
            BlockStateGenerator blockState = blockStates.put(block, blockStateGenerator);
            if (blockState != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = new HashSet();
        BiConsumer<ResourceLocation, Supplier> modelOutput = (resourceLocation, supplier) -> {
            Supplier model = models.put(resourceLocation, supplier);
            if (model != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        Consumer<Item> skippedAutoModelsOutput = skippedAutoModels::add;
        this.factories.stream().map(factory -> factory.create(blockStateOutput, modelOutput, skippedAutoModelsOutput)).forEach(PollinatedModelGenerator::run);
        Registry.f_122824_.forEach(block -> {
            if (!this.domain.equals(Registry.f_122824_.m_7981_(block).m_135827_())) {
                return;
            }
            Item item = (Item)Item.f_41373_.get(block);
            if (item != null) {
                if (skippedAutoModels.contains(item)) {
                    return;
                }
                ResourceLocation itemLocation = ModelLocationUtils.m_125571_((Item)item);
                if (!models.containsKey(itemLocation)) {
                    models.put(itemLocation, new DelegatedModel(ModelLocationUtils.m_125576_((Block)block)));
                }
            }
        });
        this.saveCollection(cache, path, blockStates, PollinatedModelProvider::createBlockStatePath);
        this.saveCollection(cache, path, models, PollinatedModelProvider::createModelPath);
    }

    private <T> void saveCollection(HashCache cache, Path rootPath, Map<T, ? extends Supplier<JsonElement>> objectToJsonMap, BiFunction<Path, T, Path> resolveObjectPath) {
        objectToJsonMap.forEach((object, supplier) -> {
            Path path = (Path)resolveObjectPath.apply(rootPath, object);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)((JsonElement)supplier.get()), (Path)path);
            }
            catch (Exception var7) {
                LOGGER.error("Couldn't save {}", (Object)path, (Object)var7);
            }
        });
    }

    private static Path createBlockStatePath(Path rootPath, Block block) {
        ResourceLocation resourceLocation = Registry.f_122824_.m_7981_((Object)block);
        return rootPath.resolve("assets/" + resourceLocation.m_135827_() + "/blockstates/" + resourceLocation.m_135815_() + ".json");
    }

    private static Path createModelPath(Path rootPath, ResourceLocation modelLocation) {
        return rootPath.resolve("assets/" + modelLocation.m_135827_() + "/models/" + modelLocation.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Block State Definitions";
    }

    @FunctionalInterface
    public static interface ModelGeneratorFactory {
        public PollinatedModelGenerator create(Consumer<BlockStateGenerator> var1, BiConsumer<ResourceLocation, Supplier<JsonElement>> var2, Consumer<Item> var3);
    }
}

