/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.entity;

import gg.moonflower.pollen.api.PollenRegistries;
import gg.moonflower.pollen.api.entity.PollenEntityTypes;
import gg.moonflower.pollen.api.entity.PollinatedBoatType;
import gg.moonflower.pollen.api.item.PollinatedBoatItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PollinatedBoat
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(PollinatedBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public PollinatedBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    public PollinatedBoat(Level level, double d, double e, double f) {
        this(PollenEntityTypes.BOAT.get(), level);
        this.m_6034_(d, e, f);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = d;
        this.f_19855_ = e;
        this.f_19856_ = f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getBoatPollenType() == null) {
            Boat boat = new Boat(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            boat.m_20359_((Entity)this);
            if (this.m_8077_()) {
                boat.m_6593_(this.m_7770_());
                boat.m_20340_(this.m_20151_());
            }
            boat.m_20331_(this.m_20147_());
            this.f_19853_.m_7967_((Entity)boat);
            if (this.m_20159_()) {
                boat.m_7998_(this.m_20202_(), true);
            }
            for (Entity passenger : this.m_20197_()) {
                passenger.m_7998_((Entity)boat, true);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public Item m_38369_() {
        PollinatedBoatType type = this.getBoatPollenType();
        return type != null ? PollinatedBoatItem.getBoatItem(type) : null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)-1);
    }

    protected void m_7380_(CompoundTag compound) {
        ResourceLocation id = PollenRegistries.BOAT_TYPE_REGISTRY.getKey(this.getBoatPollenType());
        if (id != null) {
            compound.m_128359_("Type", id.toString());
        }
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Type", 8)) {
            this.setPollenType(PollenRegistries.BOAT_TYPE_REGISTRY.get(new ResourceLocation(compound.m_128461_("Type"))));
        }
    }

    public void m_38332_(Boat.Type boatType) {
    }

    public Boat.Type m_38387_() {
        return Boat.Type.OAK;
    }

    public void setPollenType(@Nullable PollinatedBoatType boatType) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)(boatType == null ? -1 : PollenRegistries.BOAT_TYPE_REGISTRY.getId(boatType)));
    }

    public PollinatedBoatType getBoatPollenType() {
        int id = (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE);
        return id == -1 ? null : PollenRegistries.BOAT_TYPE_REGISTRY.byId(id);
    }
}

