/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.event.events;

import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.event.PollinatedEvent;
import gg.moonflower.pollen.api.event.events.forge.LootTableConstructingEventImpl;
import gg.moonflower.pollen.api.registry.EventRegistry;
import gg.moonflower.pollen.core.mixin.loot.LootPoolAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootPoolBuilderAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootTableAccessor;
import gg.moonflower.pollen.core.mixin.loot.LootTableBuilderAccessor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.ApiStatus;

@FunctionalInterface
public interface LootTableConstructingEvent {
    public static final PollinatedEvent<LootTableConstructingEvent> EVENT = EventRegistry.create(LootTableConstructingEvent.class, events -> context -> {
        for (LootTableConstructingEvent event : events) {
            event.modifyLootTable(context);
        }
    });

    public void modifyLootTable(Context var1);

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<LootPool> getPools(LootTable lootTable) {
        return LootTableConstructingEventImpl.getPools(lootTable);
    }

    public static class Context {
        private final LootTable source;
        private final ResourceLocation loadingId;
        private final LootTable.Builder builder;
        private final Map<Integer, LootPoolModifier> modifyPools;
        private final Set<Integer> removePools;
        private final Set<Integer> removeFunctions;
        private boolean changed;

        public Context(ResourceLocation loadingId, LootTable source) {
            this.loadingId = loadingId;
            this.source = source;
            this.builder = LootTable.m_79147_().m_79165_(source.m_79122_());
            this.modifyPools = new HashMap<Integer, LootPoolModifier>();
            this.removePools = new HashSet<Integer>();
            this.removeFunctions = new HashSet<Integer>();
            ((LootTableBuilderAccessor)this.builder).getPools().addAll(LootTableConstructingEvent.getPools(source));
            ((LootTableBuilderAccessor)this.builder).getFunctions().addAll(Arrays.asList(((LootTableAccessor)source).getFunctions()));
        }

        private void updatePool(int index, Consumer<LootPool.Builder> action) {
            List<LootPool> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            if (index < 0 || index >= pools.size()) {
                return;
            }
            LootPoolAccessor sourceAccessor = (LootPoolAccessor)pools.get(index);
            LootPool.Builder builder = LootPool.m_79043_().m_165133_(sourceAccessor.getPoolRolls());
            LootPoolBuilderAccessor accessor = (LootPoolBuilderAccessor)builder;
            accessor.getEntries().addAll(Arrays.asList(sourceAccessor.getEntries()));
            accessor.getConditions().addAll(Arrays.asList(sourceAccessor.getConditions()));
            accessor.getFunctions().addAll(Arrays.asList(sourceAccessor.getFunctions()));
            accessor.setBonusRolls(sourceAccessor.getBonusRolls());
            action.accept(builder);
            pools.set(index, builder.m_79082_());
            this.changed = true;
        }

        private void removeFromPool(int index, Consumer<LootPoolModifier> action) {
            List<LootPool> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            if (index < 0 || index >= pools.size()) {
                return;
            }
            action.accept(this.modifyPools.computeIfAbsent(index, __ -> new LootPoolModifier()));
            this.changed = true;
        }

        @ApiStatus.Internal
        public LootTable apply() {
            int j;
            if (!this.changed) {
                return this.source;
            }
            this.modifyPools.keySet().removeIf(this.removePools::contains);
            List<LootPool> pools = ((LootTableBuilderAccessor)this.builder).getPools();
            List<LootItemFunction> functions = ((LootTableBuilderAccessor)this.builder).getFunctions();
            for (Map.Entry<Integer, LootPoolModifier> entry : this.modifyPools.entrySet()) {
                int j2;
                int index = entry.getKey();
                if (index < 0 || index >= pools.size()) continue;
                LootPool pool = pools.get(index);
                LootPool.Builder poolBuilder = LootPool.m_79043_();
                LootPoolAccessor poolAccessor = (LootPoolAccessor)pool;
                LootPoolBuilderAccessor builderAccessor = (LootPoolBuilderAccessor)poolBuilder;
                LootPoolModifier modifier = entry.getValue();
                builderAccessor.getEntries().addAll(Arrays.asList(poolAccessor.getEntries()));
                builderAccessor.getConditions().addAll(Arrays.asList(poolAccessor.getConditions()));
                builderAccessor.getFunctions().addAll(Arrays.asList(poolAccessor.getFunctions()));
                int[] removeEntriesArray = modifier.removeEntries.stream().mapToInt(i -> i).sorted().toArray();
                int[] removeConditionsArray = modifier.removeConditions.stream().mapToInt(i -> i).sorted().toArray();
                int[] removeFunctionsArray = modifier.removeFunctions.stream().mapToInt(i -> i).sorted().toArray();
                for (j2 = 0; j2 < removeEntriesArray.length; ++j2) {
                    builderAccessor.getEntries().remove(removeEntriesArray[removeEntriesArray.length - j2 - 1]);
                }
                for (j2 = 0; j2 < removeConditionsArray.length; ++j2) {
                    builderAccessor.getConditions().remove(removeConditionsArray[removeConditionsArray.length - j2 - 1]);
                }
                for (j2 = 0; j2 < removeFunctionsArray.length; ++j2) {
                    builderAccessor.getFunctions().remove(removeFunctionsArray[removeFunctionsArray.length - j2 - 1]);
                }
                pools.set(index, poolBuilder.m_79082_());
            }
            int[] removePoolsArray = this.removePools.stream().mapToInt(i -> i).sorted().toArray();
            int[] removeFunctionsArray = this.removeFunctions.stream().mapToInt(i -> i).sorted().toArray();
            for (j = 0; j < removePoolsArray.length; ++j) {
                pools.remove(removePoolsArray[removePoolsArray.length - j - 1]);
            }
            for (j = 0; j < removeFunctionsArray.length; ++j) {
                functions.remove(removeFunctionsArray[removeFunctionsArray.length - j - 1]);
            }
            this.modifyPools.clear();
            this.removePools.clear();
            this.removeFunctions.clear();
            return this.builder.m_79167_();
        }

        public void addPool(LootPool lootPool) {
            ((LootTableBuilderAccessor)this.builder).getPools().add(lootPool);
            this.changed = true;
        }

        public void addPool(LootPool.Builder lootPool) {
            this.builder.m_79161_(lootPool);
            this.changed = true;
        }

        public void addFunction(LootItemFunction function) {
            ((LootTableBuilderAccessor)this.builder).getFunctions().add(function);
            this.changed = true;
        }

        public void addFunction(LootItemFunction.Builder function) {
            this.builder.m_5577_(function);
            this.changed = true;
        }

        public void setParamSet(LootContextParamSet parameterSet) {
            this.builder.m_79165_(parameterSet);
            this.changed = true;
        }

        public void insertPool(int poolIndex, LootPool ... pools) {
            this.updatePool(poolIndex, pool -> {
                LootPoolBuilderAccessor poolAccessor = (LootPoolBuilderAccessor)pool;
                for (LootPool injectPool : pools) {
                    LootPoolAccessor injectPoolAccessor = (LootPoolAccessor)injectPool;
                    poolAccessor.getEntries().addAll(Arrays.asList(injectPoolAccessor.getEntries()));
                    poolAccessor.getConditions().addAll(Arrays.asList(injectPoolAccessor.getConditions()));
                    poolAccessor.getFunctions().addAll(Arrays.asList(injectPoolAccessor.getFunctions()));
                }
            });
        }

        public void insertPool(int poolIndex, LootPool.Builder ... pools) {
            this.updatePool(poolIndex, pool -> {
                LootPoolBuilderAccessor poolAccessor = (LootPoolBuilderAccessor)pool;
                for (LootPool.Builder injectPool : pools) {
                    LootPoolBuilderAccessor injectPoolAccessor = (LootPoolBuilderAccessor)injectPool;
                    poolAccessor.getEntries().addAll(injectPoolAccessor.getEntries());
                    poolAccessor.getConditions().addAll(injectPoolAccessor.getConditions());
                    poolAccessor.getFunctions().addAll(injectPoolAccessor.getFunctions());
                }
            });
        }

        public void insertEntry(int poolIndex, LootPoolEntryContainer ... entries) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getEntries().addAll(Arrays.asList(entries)));
        }

        public void insertEntry(int poolIndex, LootPoolEntryContainer.Builder<?> ... entries) {
            this.updatePool(poolIndex, pool -> {
                for (LootPoolEntryContainer.Builder entry : entries) {
                    pool.m_79076_(entry);
                }
            });
        }

        public void insertCondition(int poolIndex, LootItemCondition ... conditions) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getConditions().addAll(Arrays.asList(conditions)));
        }

        public void insertCondition(int poolIndex, LootItemCondition.Builder ... conditions) {
            this.updatePool(poolIndex, pool -> {
                for (LootItemCondition.Builder condition : conditions) {
                    pool.m_6509_(condition);
                }
            });
        }

        public void insertFunction(int poolIndex, LootItemFunction ... functions) {
            this.updatePool(poolIndex, pool -> ((LootPoolBuilderAccessor)pool).getFunctions().addAll(Arrays.asList(functions)));
        }

        public void insertFunction(int poolIndex, LootItemFunction.Builder ... functions) {
            this.updatePool(poolIndex, pool -> {
                for (LootItemFunction.Builder function : functions) {
                    pool.m_5577_(function);
                }
            });
        }

        public void removeEntry(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> modifier.removeEntries.add(index));
        }

        public void removeCondition(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> modifier.removeConditions.add(index));
        }

        public void removeFunction(int poolIndex, int index) {
            this.removeFromPool(poolIndex, modifier -> modifier.removeFunctions.add(index));
        }

        public void removePool(int index) {
            this.removePools.add(index);
            this.changed = true;
        }

        public void removeFunction(int index) {
            this.removeFunctions.add(index);
            this.changed = true;
        }

        public ResourceLocation getId() {
            return this.loadingId;
        }

        public LootTable getLootTable() {
            return this.source;
        }

        private static class LootPoolModifier {
            private final Set<Integer> removeEntries = new HashSet<Integer>();
            private final Set<Integer> removeConditions = new HashSet<Integer>();
            private final Set<Integer> removeFunctions = new HashSet<Integer>();

            private LootPoolModifier() {
            }
        }
    }
}

