/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.item;

import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import gg.moonflower.pollen.api.item.TabFiller;
import gg.moonflower.pollen.api.registry.content.DispenseItemBehaviorRegistry;
import gg.moonflower.pollen.core.mixin.BucketItemAccessor;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class BucketItemBase
extends BucketItem {
    private static final DispenseItemBehavior DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            BucketItem bucket = (BucketItem)stack.m_41720_();
            BlockPos pos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            ServerLevel level = source.m_7727_();
            if (bucket.m_142073_(null, (Level)level, pos, null)) {
                bucket.m_142131_(null, (Level)level, stack, pos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return this.defaultDispenseItemBehavior.m_6115_(source, stack);
        }
    };
    protected final Supplier<? extends Fluid> fluid;

    public BucketItemBase(Supplier<? extends Fluid> fluid, Item.Properties builder) {
        super(Fluids.f_76191_, builder);
        this.fluid = fluid;
        DispenseItemBehaviorRegistry.register((ItemLike)this, DISPENSE_BEHAVIOR);
    }

    public BucketItemBase(Fluid fluid, Item.Properties builder) {
        this(() -> fluid, builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        Fluid content = this.getFluid();
        ItemStack itemStack = player.m_21120_(hand);
        BlockHitResult hitResult = BucketItemBase.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(content == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos pos = hitResult.m_82425_();
        Direction direction = hitResult.m_82434_();
        BlockPos offsetPos = pos.m_142300_(direction);
        if (level.m_7966_(player, pos) && player.m_36204_(offsetPos, direction, itemStack)) {
            BlockState blockState = level.m_8055_(pos);
            if (content == Fluids.f_76191_) {
                BucketPickup bucketPickup;
                ItemStack itemStack2;
                Block block = blockState.m_60734_();
                if (block instanceof BucketPickup && !(itemStack2 = (bucketPickup = (BucketPickup)block).m_142598_((LevelAccessor)level, pos, blockState)).m_41619_()) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    bucketPickup.m_142298_().ifPresent(soundEvent -> player.m_5496_(soundEvent, 1.0f, 1.0f));
                    level.m_142346_((Entity)player, GameEvent.f_157816_, pos);
                    ItemStack itemStack3 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)itemStack2);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemStack2);
                    }
                    return InteractionResultHolder.m_19092_((Object)itemStack3, (boolean)level.m_5776_());
                }
            } else {
                BlockPos emptyPos;
                BlockPos blockPos = emptyPos = blockState.m_60734_() instanceof LiquidBlockContainer && content == Fluids.f_76193_ ? pos : offsetPos;
                if (this.m_142073_(player, level, emptyPos, hitResult)) {
                    this.m_142131_(player, level, itemStack, emptyPos);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, emptyPos, itemStack);
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    return InteractionResultHolder.m_19092_((Object)BucketItemBase.m_40699_((ItemStack)itemStack, (Player)player), (boolean)level.m_5776_());
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            TabFiller.insert(new ItemStack((ItemLike)this), false, items, stack -> stack.m_41720_() instanceof BucketItem && "minecraft".equals(Registry.f_122827_.m_7981_((Object)stack.m_41720_()).m_135827_()) && (stack.m_41720_() == Items.f_42447_ || ((BucketItemAccessor)stack.m_41720_()).getContent() != Fluids.f_76193_));
        }
    }

    public boolean m_142073_(@Nullable Player player, Level level, BlockPos blockPos, @Nullable BlockHitResult blockHitResult) {
        boolean bl2;
        Fluid content = this.getFluid();
        if (!(content instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockState = level.m_8055_(blockPos);
        Block block = blockState.m_60734_();
        Material material = blockState.m_60767_();
        boolean bl = blockState.m_60722_(content);
        boolean bl3 = bl2 = blockState.m_60795_() || bl || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)level, blockPos, blockState, content);
        if (!bl2) {
            return blockHitResult != null && this.m_142073_(player, level, blockHitResult.m_82425_().m_142300_(blockHitResult.m_82434_()), null);
        }
        if (level.m_6042_().m_63951_() && content.m_205067_(FluidTags.f_13131_)) {
            int i = blockPos.m_123341_();
            int j = blockPos.m_123342_();
            int k = blockPos.m_123343_();
            level.m_5594_(player, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && content == Fluids.f_76193_) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)level, blockPos, blockState, ((FlowingFluid)content).m_76068_(false));
            this.m_7718_(player, (LevelAccessor)level, blockPos);
            return true;
        }
        if (!level.m_5776_() && bl && !material.m_76332_()) {
            level.m_46961_(blockPos, true);
        }
        if (!level.m_7731_(blockPos, content.m_76145_().m_76188_(), 11) && !blockState.m_60819_().m_76170_()) {
            return false;
        }
        this.m_7718_(player, (LevelAccessor)level, blockPos);
        return true;
    }

    protected void m_7718_(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        SoundEvent soundEvent;
        Fluid content = this.getFluid();
        if (content instanceof PollinatedFluid) {
            soundEvent = ((PollinatedFluid)content).getEmptySound().orElse(null);
        } else {
            SoundEvent soundEvent2 = soundEvent = content.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        if (soundEvent != null) {
            level.m_5594_(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }
}

