/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry.client.forge;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="pollen", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
@ApiStatus.Internal
public class ColorRegistryImpl {
    private static final Set<Consumer<ColorHandlerEvent.Item>> ITEM_COLORS = ConcurrentHashMap.newKeySet();
    private static final Set<Consumer<ColorHandlerEvent.Block>> BLOCK_COLORS = ConcurrentHashMap.newKeySet();

    @SubscribeEvent
    public static void onEvent(ColorHandlerEvent.Item event) {
        ITEM_COLORS.forEach(consumer -> consumer.accept(event));
    }

    @SubscribeEvent
    public static void onEvent(ColorHandlerEvent.Block event) {
        BLOCK_COLORS.forEach(consumer -> consumer.accept(event));
    }

    @SafeVarargs
    public static void register(ItemColor itemColor, Supplier<? extends ItemLike> ... items) {
        ITEM_COLORS.add(event -> {
            for (Supplier item : items) {
                event.getItemColors().m_92689_(itemColor, new ItemLike[]{(ItemLike)item.get()});
            }
        });
    }

    @SafeVarargs
    public static void register(BlockColor blockColor, Supplier<? extends Block> ... blocks) {
        BLOCK_COLORS.add(event -> {
            for (Supplier block : blocks) {
                event.getBlockColors().m_92589_(blockColor, new Block[]{(Block)block.get()});
            }
        });
    }
}

