/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.registry.resource.forge;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.api.util.forge.ForgeModResourcePack;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(modid="pollen")
@ApiStatus.Internal
public class ResourceRegistryImpl {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<PackType, Set<PollinatedPreparableReloadListener>> LISTENERS = new HashMap<PackType, Set<PollinatedPreparableReloadListener>>();
    private static final Set<Pair<String, ForgeModResourcePack>> builtinResourcePacks = new HashSet<Pair<String, ForgeModResourcePack>>();

    public static synchronized void registerReloadListener(PackType type, PollinatedPreparableReloadListener listener) {
        if (!LISTENERS.computeIfAbsent(type, __ -> new HashSet()).add(listener)) {
            throw new RuntimeException("Attempted to add listener twice: " + listener.m_7812_());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(AddReloadListenerEvent event) {
        ResourceRegistryImpl.inject(PackType.SERVER_DATA, event.getListeners()).forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    private static List<PreparableReloadListener> inject(PackType type, List<PreparableReloadListener> existing) {
        Set<PollinatedPreparableReloadListener> addedListeners = LISTENERS.get(type);
        if (addedListeners == null) {
            return Collections.emptyList();
        }
        ArrayList<PollinatedPreparableReloadListener> listenersToAdd = new ArrayList<PollinatedPreparableReloadListener>(addedListeners);
        HashSet<ResourceLocation> resolvedIds = new HashSet<ResourceLocation>();
        for (PreparableReloadListener listener : existing) {
            if (!(listener instanceof PollinatedPreparableReloadListener)) continue;
            resolvedIds.add(((PollinatedPreparableReloadListener)listener).getPollenId());
        }
        int lastSize = -1;
        ArrayList<PreparableReloadListener> listeners = new ArrayList<PreparableReloadListener>();
        while (listeners.size() != lastSize) {
            lastSize = listeners.size();
            Iterator it = listenersToAdd.iterator();
            while (it.hasNext()) {
                PollinatedPreparableReloadListener pollinatedPreparableReloadListener = (PollinatedPreparableReloadListener)it.next();
                if (!resolvedIds.containsAll(pollinatedPreparableReloadListener.getPollenDependencies())) continue;
                resolvedIds.add(pollinatedPreparableReloadListener.getPollenId());
                listeners.add(pollinatedPreparableReloadListener);
                it.remove();
            }
        }
        for (PreparableReloadListener preparableReloadListener : listenersToAdd) {
            LOGGER.warn("Could not resolve dependencies for listener: " + preparableReloadListener.m_7812_() + "!");
        }
        return listeners;
    }

    public static void inject(PackType type, Consumer<Pack> consumer, Pack.PackConstructor factory) {
        for (Pair<String, ForgeModResourcePack> entry : builtinResourcePacks) {
            ForgeModResourcePack pack = (ForgeModResourcePack)((Object)entry.getSecond());
            if (pack.m_5698_(type).isEmpty()) continue;
            Pack profile = Pack.m_10430_((String)((String)entry.getFirst()), (boolean)false, () -> entry.getSecond(), (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            if (profile == null) continue;
            consumer.accept(profile);
        }
    }

    public static synchronized boolean registerBuiltinResourcePack(ResourceLocation id, PollinatedModContainer container, boolean enabledByDefault) {
        String separator = container.resolve("").getFileSystem().getSeparator();
        String subPath = ("resourcepacks/" + id.m_135815_()).replace("/", separator);
        Path resourcePackPath = container.resolve(subPath).toAbsolutePath().normalize();
        if (!Files.exists(resourcePackPath, new LinkOption[0])) {
            return false;
        }
        final String name = id.m_135827_() + "/" + id.m_135815_();
        builtinResourcePacks.add((Pair<String, ForgeModResourcePack>)Pair.of((Object)name, (Object)((Object)new ForgeModResourcePack(container, resourcePackPath, null, enabledByDefault){

            @Override
            public String m_8017_() {
                return name;
            }
        })));
        return true;
    }

    @Mod.EventBusSubscriber(modid="pollen", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusImpl {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onEvent(RegisterClientReloadListenersEvent event) {
            ResourceRegistryImpl.inject(PackType.CLIENT_RESOURCES, Collections.emptyList()).forEach(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
        }
    }
}

