/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.condition.forge;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FluidExistsCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("pollen", "fluid_exists");
    private final ResourceLocation fluid;

    public FluidExistsCondition(ResourceLocation fluid) {
        this.fluid = fluid;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return this.test();
    }

    @Deprecated
    public boolean test() {
        return ForgeRegistries.FLUIDS.containsKey(this.fluid);
    }

    public String toString() {
        return "fluid_exists(\"" + this.fluid + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<FluidExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, FluidExistsCondition value) {
            json.addProperty("fluid", value.fluid.toString());
        }

        public FluidExistsCondition read(JsonObject json) {
            return new FluidExistsCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

