/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.condition.forge;

import gg.moonflower.pollen.api.resource.condition.PollinatedResourceConditionProvider;
import gg.moonflower.pollen.api.resource.condition.forge.BlockExistsCondition;
import gg.moonflower.pollen.api.resource.condition.forge.BlockTagPopulatedCondition;
import gg.moonflower.pollen.api.resource.condition.forge.FluidExistsCondition;
import gg.moonflower.pollen.api.resource.condition.forge.FluidTagPopulatedCondition;
import gg.moonflower.pollen.api.resource.condition.forge.ForgeResourceConditionProvider;
import gg.moonflower.pollen.api.resource.condition.forge.ItemTagPopulatedCondition;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollinatedResourceConditionImpl {
    private static final PollinatedResourceConditionProvider FALSE = PollinatedResourceConditionImpl.wrap((ICondition)FalseCondition.INSTANCE);
    private static final PollinatedResourceConditionProvider TRUE = PollinatedResourceConditionImpl.wrap((ICondition)TrueCondition.INSTANCE);

    public static PollinatedResourceConditionProvider and(PollinatedResourceConditionProvider ... values) {
        return PollinatedResourceConditionImpl.wrap((ICondition)new AndCondition((ICondition[])Arrays.stream(values).map(ConditionWrapper::new).toArray(ICondition[]::new)));
    }

    public static PollinatedResourceConditionProvider FALSE() {
        return FALSE;
    }

    public static PollinatedResourceConditionProvider TRUE() {
        return TRUE;
    }

    public static PollinatedResourceConditionProvider not(PollinatedResourceConditionProvider value) {
        return PollinatedResourceConditionImpl.wrap((ICondition)new NotCondition((ICondition)new ConditionWrapper(value)));
    }

    public static PollinatedResourceConditionProvider or(PollinatedResourceConditionProvider ... values) {
        return PollinatedResourceConditionImpl.wrap((ICondition)new OrCondition((ICondition[])Arrays.stream(values).map(ConditionWrapper::new).toArray(ICondition[]::new)));
    }

    public static PollinatedResourceConditionProvider itemExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.wrap((ICondition)new ItemExistsCondition(name));
    }

    public static PollinatedResourceConditionProvider blockExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.wrap(new BlockExistsCondition(name));
    }

    public static PollinatedResourceConditionProvider fluidExists(ResourceLocation name) {
        return PollinatedResourceConditionImpl.wrap(new FluidExistsCondition(name));
    }

    public static PollinatedResourceConditionProvider itemTagPopulated(TagKey<Item> tag) {
        return PollinatedResourceConditionImpl.wrap(new ItemTagPopulatedCondition(tag.f_203868_()));
    }

    public static PollinatedResourceConditionProvider blockTagPopulated(TagKey<Block> tag) {
        return PollinatedResourceConditionImpl.wrap(new BlockTagPopulatedCondition(tag.f_203868_()));
    }

    public static PollinatedResourceConditionProvider fluidTagPopulated(TagKey<Fluid> tag) {
        return PollinatedResourceConditionImpl.wrap(new FluidTagPopulatedCondition(tag.f_203868_()));
    }

    public static PollinatedResourceConditionProvider allModsLoaded(String ... modIds) {
        return modIds.length == 1 ? PollinatedResourceConditionImpl.wrap((ICondition)new ModLoadedCondition(modIds[0])) : PollinatedResourceConditionImpl.wrap((ICondition)new AndCondition((ICondition[])Arrays.stream(modIds).map(ModLoadedCondition::new).toArray(ICondition[]::new)));
    }

    public static PollinatedResourceConditionProvider anyModsLoaded(String ... modIds) {
        return modIds.length == 1 ? PollinatedResourceConditionImpl.wrap((ICondition)new ModLoadedCondition(modIds[0])) : PollinatedResourceConditionImpl.wrap((ICondition)new OrCondition((ICondition[])Arrays.stream(modIds).map(ModLoadedCondition::new).toArray(ICondition[]::new)));
    }

    private static PollinatedResourceConditionProvider wrap(ICondition condition) {
        return new ForgeResourceConditionProvider(condition);
    }

    private static class ConditionWrapper
    implements ICondition {
        private final PollinatedResourceConditionProvider provider;

        private ConditionWrapper(PollinatedResourceConditionProvider provider) {
            this.provider = provider;
        }

        public ResourceLocation getID() {
            return this.provider.getName();
        }

        public boolean test(ICondition.IContext context) {
            return this.test();
        }

        @Deprecated
        public boolean test() {
            return false;
        }
    }
}

