/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.modifier;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.event.events.AdvancementConstructingEvent;
import gg.moonflower.pollen.api.event.events.LootTableConstructingEvent;
import gg.moonflower.pollen.api.event.events.client.resource.ModelEvents;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ReloadStartListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifier;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierType;
import gg.moonflower.pollen.api.resource.modifier.serializer.DataModifierSerializer;
import gg.moonflower.pollen.api.resource.modifier.serializer.ResourceModifierSerializer;
import gg.moonflower.pollen.api.resource.modifier.type.AdvancementModifier;
import gg.moonflower.pollen.api.resource.modifier.type.LootModifier;
import gg.moonflower.pollen.api.resource.modifier.type.ModelOverrideModifier;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class ResourceModifierManager {
    public static final PollinatedRegistry<ResourceModifierType> REGISTRY = PollinatedRegistry.createSimple(new ResourceLocation("pollen", "resource_modifier"));
    public static final Supplier<ResourceModifierType> ADVANCEMENT = REGISTRY.register("advancement", () -> ResourceModifierType.create(AdvancementModifier.Builder::fromJson));
    public static final Supplier<ResourceModifierType> LOOT = REGISTRY.register("loot", () -> ResourceModifierType.create(LootModifier.Builder::fromJson));
    public static final Supplier<ResourceModifierType> MODEL_OVERRIDE = REGISTRY.register("model_override", () -> ResourceModifierType.create(ModelOverrideModifier.Builder::fromJson));
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceLocation, ResourceModifier<?>> DATA_MODIFIERS = new HashMap();
    private static final Map<ResourceLocation, ResourceModifier<?>> RESOURCE_MODIFIERS = new HashMap();
    private static volatile SidedReloader serverReloader = null;
    private static final Supplier<SidedReloader> CLIENT_RELOADER = Suppliers.memoize(() -> new SidedReloader("resource", RESOURCE_MODIFIERS, type -> (n, json, inject, priority) -> {
        if (!(type.getSerializer() instanceof ResourceModifierSerializer)) {
            throw new JsonSyntaxException(REGISTRY.getKey((ResourceModifierType)type) + " is not a resource modifier");
        }
        return ((ResourceModifierSerializer)type.getSerializer()).deserialize(n, json, inject, priority);
    }));

    private ResourceModifierManager() {
    }

    @ApiStatus.Internal
    public static void init() {
        AdvancementConstructingEvent.EVENT.register((builder, context) -> ResourceModifierManager.getDataModifiersFor(ADVANCEMENT.get(), context.m_25873_()).forEachOrdered(modifier -> {
            try {
                modifier.modify(builder);
            }
            catch (Exception e) {
                LOGGER.error("Failed to apply advancement modifier {}: {}", (Object)modifier.getId(), (Object)e.getMessage());
            }
        }));
        LootTableConstructingEvent.EVENT.register(context -> {
            ResourceLocation id = context.getId();
            ResourceModifierManager.getDataModifiersFor(LOOT.get(), id).forEachOrdered(modifier -> {
                try {
                    modifier.modify(context);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to apply loot modifier {}: {}", (Object)modifier.getId(), (Object)e.getMessage());
                }
            });
        });
    }

    @ApiStatus.Internal
    public static void initClient() {
        ResourceRegistry.registerReloadListener(PackType.CLIENT_RESOURCES, CLIENT_RELOADER.get());
        ModelEvents.LOAD_BLOCK_MODEL.register((location, model) -> ResourceModifierManager.getResourceModifiersFor(MODEL_OVERRIDE.get(), location).forEachOrdered(modifier -> {
            try {
                modifier.modify(model);
            }
            catch (Exception e) {
                LOGGER.error("Failed to apply model override modifier {}: {}", (Object)modifier.getId(), (Object)e.getMessage());
            }
        }));
    }

    @ApiStatus.Internal
    public static PreparableReloadListener createServerReloader(ReloadableServerResources serverResources) {
        serverReloader = new SidedReloader("data", DATA_MODIFIERS, type -> (n, json, inject, priority) -> {
            if (!(type.getSerializer() instanceof DataModifierSerializer)) {
                throw new JsonSyntaxException(REGISTRY.getKey((ResourceModifierType)type) + " is not a data modifier");
            }
            return ((DataModifierSerializer)type.getSerializer()).deserialize(n, serverResources, json, inject, priority);
        });
        return serverReloader;
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> getServerCompleteFuture() {
        if (serverReloader == null) {
            throw new NullPointerException("Expected to wait for resource modifiers, but serverReloader was null");
        }
        if (serverReloader.getCompleteFuture() == null) {
            throw new NullPointerException("Expected to wait for resource modifiers, but serverReloader#getCompleteFuture() returned null");
        }
        return serverReloader.getCompleteFuture();
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> getClientCompleteFuture() {
        return CLIENT_RELOADER.get().getCompleteFuture();
    }

    @Nullable
    public static ResourceModifier<?> getDataModifier(ResourceLocation id) {
        return DATA_MODIFIERS.get(id);
    }

    @Nullable
    public static ResourceModifier<?> getResourceModifier(ResourceLocation id) {
        return RESOURCE_MODIFIERS.get(id);
    }

    public static <T> Stream<ResourceModifier<T>> getDataModifiersFor(ResourceModifierType type, ResourceLocation id) {
        return DATA_MODIFIERS.values().stream().filter(modifier -> modifier.getType() == type && ArrayUtils.contains((Object[])modifier.getInject(), (Object)id)).map(resourceModifier -> resourceModifier).sorted(Comparator.comparingInt(ResourceModifier::getInjectPriority).reversed());
    }

    public static <T> Stream<ResourceModifier<T>> getResourceModifiersFor(ResourceModifierType type, ResourceLocation id) {
        return RESOURCE_MODIFIERS.values().stream().filter(modifier -> modifier.getType() == type && ArrayUtils.contains((Object[])modifier.getInject(), (Object)id)).map(resourceModifier -> resourceModifier).sorted(Comparator.comparingInt(ResourceModifier::getInjectPriority).reversed());
    }

    private static ResourceModifier<?> deserialize(ResourceLocation name, JsonElement element, Function<ResourceModifierType, ResourceModifierSerializer> function) {
        ResourceLocation[] resourceLocationArray;
        JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"modifier");
        if (!json.has("inject")) {
            throw new JsonSyntaxException("Missing inject, expected to find a String or JsonArray");
        }
        ResourceLocation typeName = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"type"));
        ResourceModifierType type = REGISTRY.getOptional(typeName).orElseThrow(() -> new JsonSyntaxException("Unknown resource type: " + typeName));
        JsonElement injectElement = json.get("inject");
        if (!(injectElement.isJsonPrimitive() && injectElement.getAsJsonPrimitive().isString() || injectElement.isJsonArray())) {
            throw new JsonSyntaxException("Expected inject to be a String or JsonArray, was " + GsonHelper.m_13883_((JsonElement)injectElement));
        }
        if (injectElement.isJsonPrimitive() && injectElement.getAsJsonPrimitive().isString()) {
            ResourceLocation[] resourceLocationArray2 = new ResourceLocation[1];
            resourceLocationArray = resourceLocationArray2;
            resourceLocationArray2[0] = new ResourceLocation(GsonHelper.m_13805_((JsonElement)injectElement, (String)"inject"));
        } else {
            resourceLocationArray = JSONTupleParser.getArray(json, "inject", new ResourceLocation[0], 1, ResourceLocation::new);
        }
        ResourceLocation[] inject = resourceLocationArray;
        int priority = GsonHelper.m_13824_((JsonObject)json, (String)"injectPriority", (int)1000);
        return function.apply(type).deserialize(name, json, inject, priority).build(name);
    }

    private static class SidedReloader
    implements ReloadStartListener,
    PollinatedPreparableReloadListener {
        private static final Gson GSON = new GsonBuilder().create();
        private final String type;
        private final PreparableReloadListener listener;
        private CompletableFuture<Void> completeFuture;

        private SidedReloader(final String type, final Map<ResourceLocation, ResourceModifier<?>> resourceModifiers, final Function<ResourceModifierType, ResourceModifierSerializer> function) {
            this.type = type;
            this.listener = new SimpleJsonResourceReloadListener(GSON, "resource_modifiers"){

                protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                    HashMap modifiers = new HashMap();
                    map.forEach((name, element) -> {
                        try {
                            modifiers.put(name, ResourceModifierManager.deserialize(name, element, function));
                        }
                        catch (Exception e) {
                            LOGGER.error("Parsing error loading custom {} modifier {}: {}", (Object)type, name, (Object)e.getMessage());
                        }
                    });
                    resourceModifiers.clear();
                    resourceModifiers.putAll(modifiers);
                    LOGGER.info("Loaded {} {} modifiers", (Object)modifiers.size(), (Object)type);
                }
            };
            this.completeFuture = CompletableFuture.completedFuture(null);
        }

        @Override
        public void onReloadStart(ResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
            this.completeFuture = this.listener.m_5540_(CompletableFuture::completedFuture, resourceManager, (ProfilerFiller)InactiveProfiler.f_18554_, (ProfilerFiller)InactiveProfiler.f_18554_, Runnable::run, gameExecutor);
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return this.completeFuture.thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
        }

        @Override
        public ResourceLocation getPollenId() {
            return new ResourceLocation("pollen", this.type + "_modifiers");
        }

        public CompletableFuture<Void> getCompleteFuture() {
            return this.completeFuture;
        }
    }
}

