/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.modifier.type;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifier;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierManager;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierType;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import gg.moonflower.pollen.core.mixin.data.AdvancementBuilderAccessor;
import gg.moonflower.pollen.core.mixin.data.AdvancementRewardsAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.ArrayUtils;

public class AdvancementModifier
extends ResourceModifier<Advancement.Builder> {
    private final Map<String, Criterion> addCriteria;
    private final String[][] injectRequirements;
    private final String[][] addRequirements;
    private final AdvancementRewards addRewards;
    private final String[] removeRequirements;
    private final ResourceLocation[] removeLoot;
    private final ResourceLocation[] removeRecipes;

    public AdvancementModifier(ResourceLocation id, ResourceLocation[] inject, int priority, Map<String, Criterion> addCriteria, String[][] injectRequirements, String[][] addRequirements, AdvancementRewards addRewards, String[] removeRequirements, ResourceLocation[] removeLoot, ResourceLocation[] removeRecipes) {
        super(id, inject, priority);
        this.addCriteria = ImmutableMap.copyOf(addCriteria);
        this.injectRequirements = injectRequirements;
        this.addRequirements = addRequirements;
        this.addRewards = addRewards;
        this.removeRequirements = removeRequirements;
        this.removeLoot = removeLoot;
        this.removeRecipes = removeRecipes;
    }

    private String getCriteriaName(String criteria) {
        if (criteria.contains(":")) {
            return criteria;
        }
        if (!this.addCriteria.containsKey(criteria) && this.addCriteria.containsKey(this.id.m_135827_() + ":" + criteria)) {
            return this.id.m_135827_() + ":" + criteria;
        }
        return criteria;
    }

    public static Builder advancementModifier() {
        return new Builder();
    }

    public Builder deconstruct() {
        return new Builder(this.inject, this.priority, this.addCriteria, this.injectRequirements, this.addRequirements, this.addRewards, this.removeRequirements, this.removeLoot, this.removeRecipes);
    }

    @Override
    public void modify(Advancement.Builder resource) throws JsonParseException {
        int i;
        String[][] stringArray = this.injectRequirements;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String[] requirement;
            for (String criteria2 : requirement = stringArray[j]) {
                if (this.addCriteria.containsKey(criteria2 = this.getCriteriaName(criteria2)) || resource.m_138405_().containsKey(criteria2)) continue;
                throw new JsonSyntaxException("Unknown required criterion '" + criteria2 + "'");
            }
        }
        AdvancementBuilderAccessor accessor = (AdvancementBuilderAccessor)resource;
        if (!this.addCriteria.isEmpty()) {
            resource.m_138405_().putAll(this.addCriteria);
        }
        String[][] requirements = accessor.getRequirements();
        AdvancementRewards rewards = ((AdvancementBuilderAccessor)resource).getRewards();
        ResourceLocation[] loot = ((AdvancementRewardsAccessor)rewards).getLoot();
        ResourceLocation[] recipes = ((AdvancementRewardsAccessor)rewards).getRecipes();
        int experience = ((AdvancementRewardsAccessor)rewards).getExperience();
        if (this.removeRequirements.length > 0) {
            String[] stringArray2 = this.removeRequirements;
            int criteria2 = stringArray2.length;
            for (int j = 0; j < criteria2; ++j) {
                String remove = stringArray2[j];
                for (i = 0; i < requirements.length; ++i) {
                    requirements[i] = JSONTupleParser.remove(requirements[i], remove);
                    String[] requirement = requirements[i];
                    if (requirement.length != 0) continue;
                    System.arraycopy(requirements, i + 1, requirements, i, requirements.length - i - 1);
                    requirements = (String[][])Arrays.copyOf(requirements, requirements.length - 1);
                }
            }
            if (requirements.length == 0) {
                throw new JsonSyntaxException("At least 1 requirement must remain after removing requirements");
            }
        }
        if (this.injectRequirements.length > 0) {
            if (this.injectRequirements.length > requirements.length) {
                throw new JsonSyntaxException("Requirements can only be injected up to " + requirements.length + ", got " + this.injectRequirements.length);
            }
            for (int i2 = 0; i2 < this.injectRequirements.length; ++i2) {
                String[] requirement = this.injectRequirements[i2];
                if (requirement.length == 0) continue;
                requirements[i2] = JSONTupleParser.insert(requirements[i2], requirement);
            }
        }
        if (this.addRequirements.length > 0) {
            requirements = (String[][])JSONTupleParser.insert(requirements, this.addRequirements);
        }
        for (String[] requirement : requirements) {
            for (i = 0; i < requirement.length; ++i) {
                requirement[i] = this.getCriteriaName(requirement[i]);
            }
        }
        String[][] finalRequirements = requirements;
        resource.m_138405_().keySet().removeIf(criteria -> {
            for (Object[] objectArray : finalRequirements) {
                if (!ArrayUtils.contains((Object[])objectArray, (Object)criteria)) continue;
                return false;
            }
            return true;
        });
        accessor.setRequirements(requirements);
        AdvancementRewardsAccessor addRewards = (AdvancementRewardsAccessor)this.addRewards;
        if (this.removeLoot.length > 0) {
            ResourceLocation[] resourceLocationArray = this.removeLoot;
            int n2 = resourceLocationArray.length;
            for (int j = 0; j < n2; ++j) {
                ResourceLocation remove = resourceLocationArray[j];
                loot = JSONTupleParser.remove(loot, remove);
            }
        }
        if (this.removeRecipes.length > 0) {
            for (ResourceLocation remove : this.removeRecipes) {
                recipes = JSONTupleParser.remove(recipes, remove);
            }
        }
        if (addRewards.getLoot().length > 0) {
            loot = JSONTupleParser.insert(loot, addRewards.getLoot());
        }
        if (addRewards.getRecipes().length > 0) {
            recipes = JSONTupleParser.insert(recipes, addRewards.getRecipes());
        }
        accessor.setRewards(new AdvancementRewards(experience += addRewards.getExperience(), loot, recipes, ((AdvancementRewardsAccessor)rewards).getFunction()));
    }

    @Override
    public ResourceModifierType getType() {
        return ResourceModifierManager.ADVANCEMENT.get();
    }

    public static class Builder
    extends ResourceModifier.Builder<AdvancementModifier, Builder> {
        private final Map<String, Criterion> addCriteria;
        private final Map<String, Integer> injectRequirementsKeys;
        private final List<String> addRequirementsKeys;
        private final List<String> removeRequirements;
        private final List<ResourceLocation> removeLoot;
        private final List<ResourceLocation> removeRecipes;
        private String[][] injectRequirements;
        private String[][] addRequirements;
        private RequirementsStrategy requirementsStrategy;
        private AdvancementRewards addRewards;

        private Builder(ResourceLocation[] inject, int priority, Map<String, Criterion> addCriteria, String[][] injectRequirements, String[][] addRequirements, AdvancementRewards addRewards, String[] removeRequirements, ResourceLocation[] removeLoot, ResourceLocation[] removeRecipes) {
            super(inject, priority);
            this.addCriteria = new LinkedHashMap<String, Criterion>(addCriteria);
            this.injectRequirementsKeys = new LinkedHashMap<String, Integer>();
            this.addRequirementsKeys = new LinkedList<String>();
            this.injectRequirements = injectRequirements;
            this.addRequirements = addRequirements;
            this.addRewards = addRewards;
            this.requirementsStrategy = RequirementsStrategy.f_15978_;
            this.removeRequirements = new LinkedList<String>(Arrays.asList(removeRequirements));
            this.removeLoot = new LinkedList<ResourceLocation>(Arrays.asList(removeLoot));
            this.removeRecipes = new LinkedList<ResourceLocation>(Arrays.asList(removeRecipes));
        }

        private Builder() {
            this.addCriteria = new LinkedHashMap<String, Criterion>();
            this.injectRequirementsKeys = new LinkedHashMap<String, Integer>();
            this.addRequirementsKeys = new LinkedList<String>();
            this.injectRequirements = null;
            this.addRequirements = null;
            this.addRewards = AdvancementRewards.f_9978_;
            this.requirementsStrategy = RequirementsStrategy.f_15978_;
            this.removeRequirements = new LinkedList<String>();
            this.removeLoot = new LinkedList<ResourceLocation>();
            this.removeRecipes = new LinkedList<ResourceLocation>();
        }

        private static Map<String, Criterion> getCriteriaName(Map<String, Criterion> criteria, DeserializationContext context) {
            HashMap<String, Criterion> result = new HashMap<String, Criterion>(criteria.size());
            criteria.forEach((name, criterion) -> result.put((String)(name.contains(":") ? name : context.m_25873_().m_135827_() + ":" + name), (Criterion)criterion));
            return result;
        }

        /*
         * WARNING - void declaration
         */
        public static Builder fromJson(ResourceLocation name, ReloadableServerResources serverResources, JsonObject json, ResourceLocation[] inject, int priority) {
            void var14_25;
            ResourceLocation[] removeLoot;
            void var14_22;
            int i;
            Map<Object, Object> addCriteria;
            AdvancementRewards addRewards;
            DeserializationContext context = new DeserializationContext(name, serverResources.m_206881_());
            AdvancementRewards advancementRewards = addRewards = json.has("addRewards") ? AdvancementRewards.m_9991_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"addRewards")) : AdvancementRewards.f_9978_;
            if (json.has("addCriteria")) {
                addCriteria = Builder.getCriteriaName(Criterion.m_11426_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"addCriteria"), (DeserializationContext)context), context);
                if (addCriteria.isEmpty()) {
                    throw new JsonSyntaxException("'addCriteria' cannot be empty if it's present");
                }
            } else {
                addCriteria = Collections.emptyMap();
            }
            JsonArray injectRequirementsJson = Objects.requireNonNull(GsonHelper.m_13832_((JsonObject)json, (String)"injectRequirements", (JsonArray)new JsonArray()));
            String[][] injectRequirements = new String[injectRequirementsJson.size()][];
            for (int i2 = 0; i2 < injectRequirementsJson.size(); ++i2) {
                JsonArray requirementsJson = GsonHelper.m_13924_((JsonElement)injectRequirementsJson.get(i2), (String)("injectRequirements[" + i2 + "]"));
                injectRequirements[i2] = new String[requirementsJson.size()];
                for (int j = 0; j < requirementsJson.size(); ++j) {
                    injectRequirements[i2][j] = GsonHelper.m_13805_((JsonElement)requirementsJson.get(j), (String)("injectRequirements[" + i2 + "][" + j + "]"));
                }
            }
            JsonArray addRequirementsJson = Objects.requireNonNull(GsonHelper.m_13832_((JsonObject)json, (String)"addRequirements", (JsonArray)new JsonArray()));
            String[][] addRequirements = new String[addRequirementsJson.size()][];
            for (i = 0; i < addRequirementsJson.size(); ++i) {
                JsonArray requirementsJson = GsonHelper.m_13924_((JsonElement)addRequirementsJson.get(i), (String)("addRequirements[" + i + "]"));
                addRequirements[i] = new String[requirementsJson.size()];
                for (int j = 0; j < requirementsJson.size(); ++j) {
                    addRequirements[i][j] = GsonHelper.m_13805_((JsonElement)requirementsJson.get(j), (String)("addRequirements[" + i + "][" + j + "]"));
                }
            }
            if (injectRequirements.length == 0 && addRequirements.length == 0) {
                addRequirements = new String[addCriteria.size()][];
                i = 0;
                for (String string : addCriteria.keySet()) {
                    addRequirements[i++] = new String[]{string};
                }
            }
            String[][] i2 = addRequirements;
            int requirementsJson = i2.length;
            boolean bl = false;
            while (var14_22 < requirementsJson) {
                String[] requirement = i2[var14_22];
                if (requirement.length == 0) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                ++var14_22;
            }
            String[] removeRequirements = JSONTupleParser.getArray(json, "removeRequirements", new String[0], 0, Function.identity());
            if (json.has("removeRewards")) {
                JsonObject removeRewardsJson = GsonHelper.m_13930_((JsonObject)json, (String)"removeRewards");
                removeLoot = JSONTupleParser.getArray(removeRewardsJson, "loot", new ResourceLocation[0], 0, ResourceLocation::new);
                ResourceLocation[] resourceLocationArray = JSONTupleParser.getArray(removeRewardsJson, "recipes", new ResourceLocation[0], 0, ResourceLocation::new);
            } else {
                removeLoot = new ResourceLocation[]{};
                ResourceLocation[] resourceLocationArray = new ResourceLocation[]{};
            }
            return new Builder(inject, priority, addCriteria, injectRequirements, addRequirements, addRewards, removeRequirements, removeLoot, (ResourceLocation[])var14_25);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        protected ResourceModifierType getType() {
            return ResourceModifierManager.ADVANCEMENT.get();
        }

        public Builder addRewards(AdvancementRewards.Builder builder) {
            return this.addRewards(builder.m_10004_());
        }

        public Builder addRewards(AdvancementRewards addRewards) {
            this.addRewards = addRewards;
            return this;
        }

        public Builder addCriterion(String name, CriterionTriggerInstance triggerInstance) {
            return this.addCriterion(name, new Criterion(triggerInstance));
        }

        public Builder addCriterion(String name, Criterion criterion) {
            if (this.addCriteria.put(name, criterion) != null) {
                throw new IllegalArgumentException("Duplicate criterion " + name);
            }
            this.addRequirementsKeys.add(name);
            return this;
        }

        public Builder injectCriterion(String name, int index, CriterionTriggerInstance triggerInstance) {
            return this.injectCriterion(name, index, new Criterion(triggerInstance));
        }

        public Builder injectCriterion(String name, int index, Criterion criterion) {
            if (this.addCriteria.put(name, criterion) != null) {
                throw new IllegalArgumentException("Duplicate criterion " + name);
            }
            this.injectRequirementsKeys.put(name, index);
            return this;
        }

        public Builder removeLoot(ResourceLocation lootTable) {
            this.removeLoot.add(lootTable);
            return this;
        }

        public Builder removeRecipe(ResourceLocation recipeId) {
            this.removeRecipes.add(recipeId);
            return this;
        }

        public Builder addRequirements(RequirementsStrategy requirementsStrategy) {
            this.requirementsStrategy = requirementsStrategy;
            return this;
        }

        private void initRequirements() {
            if (this.addRequirements == null) {
                this.addRequirements = this.requirementsStrategy.m_15985_(this.addRequirementsKeys);
            }
            if (this.injectRequirements == null) {
                Map.Entry[] entries = (Map.Entry[])this.injectRequirementsKeys.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).toArray(Map.Entry[]::new);
                this.injectRequirements = new String[this.injectRequirementsKeys.values().stream().mapToInt(i -> i).max().orElse(0)][];
                LinkedList<String> list = new LinkedList<String>();
                int currentIndex = 0;
                for (Map.Entry entry : entries) {
                    if ((Integer)entry.getValue() != currentIndex) {
                        this.injectRequirements[currentIndex] = list.toArray(new String[0]);
                        currentIndex = (Integer)entry.getValue();
                        list.clear();
                    }
                    list.add((String)entry.getKey());
                }
                if (!list.isEmpty()) {
                    this.injectRequirements[currentIndex] = list.toArray(new String[0]);
                }
            }
        }

        @Override
        public AdvancementModifier build(ResourceLocation id) {
            if (this.inject.isEmpty()) {
                throw new IllegalStateException("'inject' must be defined");
            }
            this.initRequirements();
            return new AdvancementModifier(id, this.inject.toArray(new ResourceLocation[0]), this.priority, this.addCriteria, this.injectRequirements, this.addRequirements, this.addRewards, this.removeRequirements.toArray(new String[0]), this.removeLoot.toArray(new ResourceLocation[0]), this.removeRecipes.toArray(new ResourceLocation[0]));
        }

        @Override
        protected void serializeProperties(JsonObject json) {
            this.initRequirements();
            if (!this.addCriteria.isEmpty()) {
                JsonObject addCriteriaJson = new JsonObject();
                for (Map.Entry entry : this.addCriteria.entrySet()) {
                    addCriteriaJson.add((String)entry.getKey(), ((Criterion)entry.getValue()).m_11425_());
                }
                json.add("addCriteria", (JsonElement)addCriteriaJson);
            }
            if (this.addRequirements.length > 0) {
                JsonArray addRequirementsJson = new JsonArray();
                for (String[] addRequirement : this.addRequirements) {
                    JsonArray addRequirementJson = new JsonArray();
                    for (String criterion : addRequirement) {
                        addRequirementJson.add(criterion);
                    }
                    addRequirementsJson.add((JsonElement)addRequirementJson);
                }
                json.add("addRequirements", (JsonElement)addRequirementsJson);
            }
            if (this.injectRequirements.length > 0) {
                JsonArray injectRequirementsJson = new JsonArray();
                for (String[] injectRequirement : this.injectRequirements) {
                    JsonArray injectRequirementJson = new JsonArray();
                    for (String criterion : injectRequirement) {
                        injectRequirementJson.add(criterion);
                    }
                    injectRequirementsJson.add((JsonElement)injectRequirementJson);
                }
                json.add("injectRequirements", (JsonElement)injectRequirementsJson);
            }
            json.add("addRewards", this.addRewards.m_9997_());
            if (!this.removeRequirements.isEmpty()) {
                JsonArray removeRequirementsJson = new JsonArray();
                for (String string : this.removeRequirements) {
                    removeRequirementsJson.add(string);
                }
                json.add("removeRequirements", (JsonElement)removeRequirementsJson);
            }
            if (!this.removeLoot.isEmpty()) {
                JsonArray removeLootJson = new JsonArray();
                for (ResourceLocation resourceLocation : this.removeLoot) {
                    removeLootJson.add(resourceLocation.toString());
                }
                json.add("removeLoot", (JsonElement)removeLootJson);
            }
            if (!this.removeRecipes.isEmpty()) {
                JsonArray removeRecipesJson = new JsonArray();
                for (ResourceLocation resourceLocation : this.removeRecipes) {
                    removeRecipesJson.add(resourceLocation.toString());
                }
                json.add("removeRecipes", (JsonElement)removeRecipesJson);
            }
        }
    }
}

