/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.sync.forge;

import gg.moonflower.pollen.api.sync.DataComponent;
import gg.moonflower.pollen.api.sync.SyncedDataKey;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import gg.moonflower.pollen.api.sync.forge.ForgeDataComponent;
import gg.moonflower.pollen.core.network.PollenMessages;
import gg.moonflower.pollen.core.network.forge.ClientboundUpdateSyncedDataPacket;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="pollen")
@ApiStatus.Internal
public class SyncedDataManagerImpl {
    public static final Capability<ForgeDataComponent> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ForgeDataComponent>(){});

    private static LazyOptional<ForgeDataComponent> getDataComponent(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    @SubscribeEvent
    public static void onEvent(RegisterCapabilitiesEvent event) {
        event.register(ForgeDataComponent.class);
    }

    @SubscribeEvent
    public static void onEvent(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(new ResourceLocation("pollen", "synced_data"), (ICapabilityProvider)new Provider());
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            Entity target = event.getTarget();
            SyncedDataManagerImpl.getDataComponent(target).ifPresent(component -> {
                if (component.shouldSyncWith(target, (Entity)player)) {
                    PollenMessages.PLAY.sendTo(player, new ClientboundUpdateSyncedDataPacket(target, (Entity)player, true));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            SyncedDataManagerImpl.getDataComponent((Entity)player).ifPresent(component -> {
                if (component.shouldSyncWith((Entity)player, (Entity)player)) {
                    PollenMessages.PLAY.sendTo(player, new ClientboundUpdateSyncedDataPacket((Entity)player, (Entity)player, true));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getOriginal() instanceof ServerPlayer && event.getPlayer() instanceof ServerPlayer) {
            ServerPlayer original = (ServerPlayer)event.getOriginal();
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            Optional originalOptional = SyncedDataManagerImpl.getDataComponent((Entity)original).resolve();
            Optional copyOptional = SyncedDataManagerImpl.getDataComponent((Entity)player).resolve();
            if (!originalOptional.isPresent() || !copyOptional.isPresent()) {
                return;
            }
            ForgeDataComponent oldHolder = (ForgeDataComponent)originalOptional.get();
            ForgeDataComponent newHolder = (ForgeDataComponent)copyOptional.get();
            if (oldHolder.shouldCopyForRespawn(!event.isWasDeath(), player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_))) {
                newHolder.copyForRespawn(oldHolder, !event.isWasDeath());
            }
            if (newHolder.shouldSyncWith((Entity)player, (Entity)player)) {
                PollenMessages.PLAY.sendTo(player, new ClientboundUpdateSyncedDataPacket((Entity)player, (Entity)player, true));
            }
        }
    }

    public static void sync(Entity entity) {
        SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> {
            if (component.isDirty()) {
                for (ServerPlayer other : ((ServerLevel)entity.f_19853_).m_142572_().m_6846_().m_11314_()) {
                    if (!component.shouldSyncWith(entity, (Entity)other)) continue;
                    PollenMessages.PLAY.sendTo(other, new ClientboundUpdateSyncedDataPacket(entity, (Entity)other, false));
                }
                component.clean();
            }
        });
    }

    public static <T> void set(Entity entity, SyncedDataKey<T> key, T value) {
        SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> {
            SyncedDataManager.markDirty();
            component.setValue(key, value);
        });
    }

    public static <T> T get(Entity entity, SyncedDataKey<T> key) {
        LazyOptional<ForgeDataComponent> optional = SyncedDataManagerImpl.getDataComponent(entity);
        return optional.isPresent() ? ((ForgeDataComponent)optional.orElseThrow(() -> new IllegalStateException("Component should be present"))).getValue(key) : key.getDefaultValueSupplier().get();
    }

    public static void writePacketData(FriendlyByteBuf buf, Entity provider, Entity entity, boolean sync) {
        if (sync) {
            SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> component.writeSyncPacket(buf, provider, entity));
        } else {
            SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> component.writeUpdatePacket(buf, provider, entity));
        }
    }

    public static void readPacketData(FriendlyByteBuf buf, Entity entity) {
        SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> component.applySyncPacket(buf));
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final ForgeDataComponent component = new ForgeDataComponent();
        private final LazyOptional<ForgeDataComponent> optional = LazyOptional.of(() -> this.component);

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.component.writeToNbt(tag, DataComponent.NbtWriteMode.SAVE);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.component.readFromNbt(tag);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return CAPABILITY.orEmpty(capability, this.optional);
        }
    }
}

