/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class VoxelShapeHelper {
    private VoxelShapeHelper() {
    }

    public static VoxelShape makeCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, Direction.EAST);
            case Direction.Axis.Y -> VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, Direction.UP);
            case Direction.Axis.Z -> VoxelShapeHelper.makeCuboidShape(x1, y1, z1, x2, y2, z2, Direction.SOUTH);
        };
    }

    public static VoxelShape makeCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2, Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Block.m_49796_((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2);
            case Direction.DOWN -> Block.m_49796_((double)x1, (double)(16.0 - z2), (double)y1, (double)x2, (double)(16.0 - z1), (double)y2);
            case Direction.NORTH -> Block.m_49796_((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            case Direction.EAST -> Block.m_49796_((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            case Direction.SOUTH -> Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            case Direction.WEST -> Block.m_49796_((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
        };
    }

    public static final class Builder {
        private final Set<VoxelShape> shapes;

        public Builder() {
            this.shapes = new HashSet<VoxelShape>();
        }

        public Builder(Builder other) {
            this.shapes = new HashSet<VoxelShape>(other.shapes);
        }

        private Builder transformRaw(Function<AABB, VoxelShape> transformer) {
            Builder newBuilder = new Builder();
            for (VoxelShape shape : this.shapes) {
                HashSet<VoxelShape> rotatedShapes = new HashSet<VoxelShape>();
                for (AABB box : shape.m_83299_()) {
                    rotatedShapes.add(transformer.apply(box));
                }
                VoxelShape result = Shapes.m_83040_();
                for (VoxelShape rotatedShape : rotatedShapes) {
                    result = Shapes.m_83148_((VoxelShape)result, (VoxelShape)rotatedShape, (BooleanOp)BooleanOp.f_82695_);
                }
                newBuilder.append(result.m_83296_());
            }
            return newBuilder;
        }

        public Builder append(VoxelShape ... shapes) {
            this.shapes.addAll(Arrays.asList(shapes));
            return this;
        }

        public Builder append(Builder other) {
            this.shapes.addAll(other.shapes);
            return this;
        }

        public Builder translate(double x, double y, double z) {
            return this.transformRaw(box -> Block.m_49796_((double)(box.f_82288_ * 16.0 + x), (double)(box.f_82289_ * 16.0 + y), (double)(box.f_82290_ * 16.0 + z), (double)(box.f_82291_ * 16.0 + x), (double)(box.f_82292_ * 16.0 + y), (double)(box.f_82293_ * 16.0 + z)));
        }

        public Builder rotate(Direction.Axis axis) {
            return this.transformRaw(box -> VoxelShapeHelper.makeCuboidShape(box.f_82288_ * 16.0, box.f_82289_ * 16.0, box.f_82290_ * 16.0, box.f_82291_ * 16.0, box.f_82292_ * 16.0, box.f_82293_ * 16.0, axis));
        }

        public Builder rotate(Direction direction) {
            return this.transformRaw(box -> VoxelShapeHelper.makeCuboidShape(box.f_82288_ * 16.0, box.f_82289_ * 16.0, box.f_82290_ * 16.0, box.f_82291_ * 16.0, box.f_82292_ * 16.0, box.f_82293_ * 16.0, direction));
        }

        public Builder scale(double x, double y, double z) {
            return this.transformRaw(box -> Block.m_49796_((double)(box.f_82288_ * 16.0 * x), (double)(box.f_82289_ * 16.0 * y), (double)(box.f_82290_ * 16.0 * z), (double)(box.f_82291_ * 16.0 * x), (double)(box.f_82292_ * 16.0 * y), (double)(box.f_82293_ * 16.0 * z)));
        }

        public VoxelShape build() {
            return this.build(BooleanOp.f_82695_);
        }

        public VoxelShape build(BooleanOp combineFunction) {
            if (this.shapes.isEmpty()) {
                return Shapes.m_83040_();
            }
            VoxelShape result = Shapes.m_83040_();
            for (VoxelShape shape : this.shapes) {
                result = Shapes.m_83148_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)combineFunction);
            }
            return result.m_83296_();
        }
    }
}

