/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util.forge;

import com.google.common.base.Charsets;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.ResourceLocationException;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ForgeModResourcePack
extends AbstractPackResources {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern RESOURCE_PACK_PATH = Pattern.compile("[a-z0-9-_]+");
    private final PollinatedModContainer container;
    private final Path basePath;
    private final AutoCloseable closer;
    private final String separator;
    private final boolean enabledByDefault;

    public ForgeModResourcePack(PollinatedModContainer container, Path path, AutoCloseable closer, boolean enabledByDefault) {
        super(null);
        this.container = container;
        this.basePath = path.toAbsolutePath().normalize();
        this.closer = closer;
        this.separator = this.basePath.getFileSystem().getSeparator();
        this.enabledByDefault = enabledByDefault;
    }

    private Path getPath(String filename) {
        Path childPath = this.basePath.resolve(filename.replace("/", this.separator)).toAbsolutePath().normalize();
        if (childPath.startsWith(this.basePath) && Files.exists(childPath, new LinkOption[0])) {
            return childPath;
        }
        return null;
    }

    protected InputStream m_5541_(String filename) throws IOException {
        Path path = this.getPath(filename);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        if ("pack.mcmeta".equals(filename)) {
            String description = this.m_8017_();
            description = description == null ? "" : description.replaceAll("\"", "\\\"");
            String pack = String.format("{\"pack\":{\"pack_format\":" + SharedConstants.m_183709_().getPackVersion(com.mojang.bridge.game.PackType.RESOURCE) + ",\"description\":\"%s\"}}", description);
            return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
        }
        throw new FileNotFoundException("\"" + filename + "\" in " + this.container.getBrand() + " Mod \"" + this.container.getId() + "\"");
    }

    protected boolean m_6105_(String filename) {
        if ("pack.mcmeta".equals(filename)) {
            return true;
        }
        Path path = this.getPath(filename);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    public Collection<ResourceLocation> m_7466_(PackType type, String namespace, String path, int depth, Predicate<String> predicate) {
        Path searchPath;
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        String nioPath = path.replace("/", this.separator);
        Path namespacePath = this.getPath(type.m_10305_() + "/" + namespace);
        if (namespacePath != null && Files.exists(searchPath = namespacePath.resolve(nioPath).toAbsolutePath().normalize(), new LinkOption[0])) {
            try {
                Files.walk(searchPath, depth, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                    String filename = p.getFileName().toString();
                    return !filename.endsWith(".mcmeta") && predicate.test(filename);
                }).map(namespacePath::relativize).map(p -> p.toString().replace(this.separator, "/")).forEach(s -> {
                    try {
                        ids.add(new ResourceLocation(namespace, s));
                    }
                    catch (ResourceLocationException e) {
                        LOGGER.error(e.getMessage());
                    }
                });
            }
            catch (IOException var11) {
                LOGGER.warn("getResources at " + path + " in namespace " + namespace + ", mod " + this.container.getId() + " failed!", (Throwable)var11);
            }
        }
        return ids;
    }

    public Set<String> m_5698_(PackType type) {
        try {
            Path typePath = this.getPath(type.m_10305_());
            if (typePath == null || !Files.isDirectory(typePath, new LinkOption[0])) {
                return Collections.emptySet();
            }
            HashSet<String> namespaces = new HashSet<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(typePath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path path : stream) {
                    String s = path.getFileName().toString();
                    if (RESOURCE_PACK_PATH.matcher(s = s.replace(this.separator, "")).matches()) {
                        namespaces.add(s);
                        continue;
                    }
                    LOGGER.warn(((Object)((Object)this)).getClass().getSimpleName() + ": ignored invalid namespace: {} in mod ID {}", (Object)s, (Object)this.container.getId());
                }
            }
            return namespaces;
        }
        catch (IOException e) {
            LOGGER.warn("getNamespaces in mod " + this.container.getId() + " failed!", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String m_8017_() {
        return this.container.getDisplayName();
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault;
    }
}

