/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util.forge;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegistryCodec<T extends IForgeRegistryEntry<T>>
implements Codec<T>,
Keyable {
    private final Supplier<IForgeRegistry<T>> registry;

    private ForgeRegistryCodec(Supplier<IForgeRegistry<T>> registry) {
        this.registry = registry;
    }

    public static <T extends IForgeRegistryEntry<T>> ForgeRegistryCodec<T> create(IForgeRegistry<T> registry) {
        return new ForgeRegistryCodec<T>(() -> registry);
    }

    public static <T extends IForgeRegistryEntry<T>> ForgeRegistryCodec<T> create(Supplier<IForgeRegistry<T>> registry) {
        return new ForgeRegistryCodec<T>(registry);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
        return ResourceLocation.f_135803_.decode(ops, input).flatMap(pair -> {
            IForgeRegistryEntry t = this.registry.get().getValue((ResourceLocation)pair.getFirst());
            return t == null ? DataResult.error((String)("Unknown registry key: " + pair.getFirst())) : DataResult.success((Object)Pair.of((Object)t, (Object)pair.getSecond()));
        });
    }

    public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
        ResourceLocation resourcelocation = this.registry.get().getKey(input);
        if (resourcelocation == null) {
            return DataResult.error((String)("Unknown registry element " + input));
        }
        return ops.mergeToPrimitive(prefix, ops.createString(resourcelocation.toString()));
    }

    public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
        return this.registry.get().getKeys().stream().map(location -> ops.createString(location.toString()));
    }
}

