/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core;

import com.google.common.base.Stopwatch;
import gg.moonflower.pollen.api.client.util.TextureDownloader;
import gg.moonflower.pollen.api.event.events.client.InputEvents;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.client.profile.ProfileManager;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;

@ApiStatus.Internal
public class DebugInputs {
    static void init() {
        InputEvents.KEY_INPUT_EVENT.register(DebugInputs::onKeyInput);
    }

    private static boolean onKeyInput(int key, int scanCode, int action, int modifiers) {
        if (Platform.isProduction() || Minecraft.m_91087_().f_91080_ instanceof ChatScreen || action != 1) {
            return false;
        }
        if (key == 92) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if ((modifiers & 4) > 0) {
                if (player == null) {
                    return true;
                }
                Stopwatch timer = Stopwatch.createStarted();
                UUID id = Minecraft.m_91087_().m_91094_().m_92548_().getId();
                ProfileManager.clearCache(id);
                EntitlementManager.clearCache();
                CompletableFuture.allOf(new CompletableFuture[]{GeometryModelManager.reload(false), GeometryTextureManager.reload(false), AnimationManager.reload(false), EntitlementManager.reload(true, CompletableFuture::completedFuture).thenCompose(__ -> EntitlementManager.getEntitlementsFuture(id))}).handle((u, t) -> {
                    timer.stop();
                    Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)new TextComponent("").m_7220_((Component)new TranslatableComponent("debug.prefix").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})).m_130946_(" Took " + timer + " to reload entitlements"));
                    return u;
                });
                return true;
            }
            try {
                Path outputFolder = Paths.get(Minecraft.m_91087_().f_91069_.toURI()).resolve("debug-out");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                for (int i = 0; i < 1024; ++i) {
                    if (!GL11C.glIsTexture((int)i)) continue;
                    result.add(TextureDownloader.save(Integer.toString(i), outputFolder, i));
                }
                CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.m_137581_().m_137644_(outputFolder.toFile()), (Executor)Minecraft.m_91087_());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

