/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.pollen.api.PollenRegistries;
import gg.moonflower.pollen.api.block.PollinatedLiquidBlock;
import gg.moonflower.pollen.api.block.PollinatedStandingSignBlock;
import gg.moonflower.pollen.api.block.PollinatedWallSignBlock;
import gg.moonflower.pollen.api.config.ConfigManager;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.api.datagen.provider.loot_table.PollinatedLootTableProvider;
import gg.moonflower.pollen.api.entity.PollinatedBoatType;
import gg.moonflower.pollen.api.item.BucketItemBase;
import gg.moonflower.pollen.api.item.PollinatedBoatItem;
import gg.moonflower.pollen.api.item.SpawnEggItemBase;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import gg.moonflower.pollen.api.registry.PollinatedBlockRegistry;
import gg.moonflower.pollen.api.registry.PollinatedFluidRegistry;
import gg.moonflower.pollen.api.registry.PollinatedRegistry;
import gg.moonflower.pollen.api.registry.content.CompostablesRegistry;
import gg.moonflower.pollen.api.registry.content.DispenseItemBehaviorRegistry;
import gg.moonflower.pollen.api.registry.content.FlammabilityRegistry;
import gg.moonflower.pollen.api.registry.content.FlatteningRegistry;
import gg.moonflower.pollen.api.registry.content.FurnaceFuelRegistry;
import gg.moonflower.pollen.api.registry.resource.TagRegistry;
import gg.moonflower.pollen.core.Pollen;
import gg.moonflower.pollen.core.client.render.DebugPollenFlowerPotRenderer;
import gg.moonflower.pollen.core.datagen.TestBlockLootGenerator;
import gg.moonflower.pollen.core.test.TestFluid;
import gg.moonflower.pollen.core.test.TestPollenFluidBehavior;
import gg.moonflower.pollen.core.test.TestServerConfig;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererRegistry;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollenTest {
    private static final PollinatedRegistry<Item> ITEMS = PollenTest.create(() -> PollinatedRegistry.create(Registry.f_122827_, "pollen"));
    private static final PollinatedBlockRegistry BLOCKS = PollenTest.create(() -> PollinatedRegistry.createBlock(ITEMS));
    private static final PollinatedFluidRegistry FLUIDS = PollenTest.create(() -> PollinatedRegistry.createFluid("pollen"));
    private static final PollinatedRegistry<PollinatedBoatType> BOATS = PollenTest.create(() -> PollinatedRegistry.create(PollenRegistries.BOAT_TYPE_REGISTRY, "pollen"));
    public static final TagKey<Fluid> TEST_TAG = PollenTest.create(() -> TagRegistry.bindFluid(new ResourceLocation("pollen", "test")));
    public static final TestServerConfig SERVER_CONFIG = PollenTest.create(() -> ConfigManager.register("pollen", PollinatedConfigType.SERVER, TestServerConfig::new));
    public static final Supplier<PollinatedBoatType> TEST_BOAT = PollenTest.create(() -> Objects.requireNonNull(BOATS).register("test_boat", () -> new PollinatedBoatType(new ResourceLocation("textures/entity/ghast/ghast.png"))));
    public static final Supplier<FlowingFluid> TEST_FLUID = PollenTest.create(() -> Objects.requireNonNull(FLUIDS).register("test", TestFluid.Source::new));
    public static final Supplier<FlowingFluid> FLOWING_TEST_FLUID = PollenTest.create(() -> Objects.requireNonNull(FLUIDS).register("flowing_test", TestFluid.Flowing::new));
    public static final Supplier<Block> TEST = PollenTest.create(() -> Objects.requireNonNull(BLOCKS).register("test", () -> new PollinatedLiquidBlock(TEST_FLUID, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_())));
    public static final Supplier<Item> TEST_BUCKET = PollenTest.create(() -> Objects.requireNonNull(ITEMS).register("test", () -> new BucketItemBase(TEST_FLUID, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(CreativeModeTab.f_40753_))));
    public static final Supplier<Item> TEST_SPAWN_EGG = PollenTest.create(() -> Objects.requireNonNull(ITEMS).register("test_spawn_egg", () -> new SpawnEggItemBase<EntityType>(() -> EntityType.f_20460_, 0, 0, new Item.Properties().m_41491_(CreativeModeTab.f_40753_))));
    public static final Supplier<Item> TEST_BOAT_ITEM = PollenTest.create(() -> Objects.requireNonNull(ITEMS).register("test_boat", () -> new PollinatedBoatItem(Objects.requireNonNull(TEST_BOAT), new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40752_))));
    public static final Pair<Supplier<PollinatedStandingSignBlock>, Supplier<PollinatedWallSignBlock>> TEST_SIGN = PollenTest.create(() -> Objects.requireNonNull(BLOCKS).registerSign("test", Material.f_76320_, MaterialColor.f_76361_));

    static void onClient() {
        BlockRendererRegistry.register(Blocks.f_50276_, (BlockRenderer)new DebugPollenFlowerPotRenderer());
    }

    static void onCommon() {
        Objects.requireNonNull(ITEMS).register(Pollen.PLATFORM);
        Objects.requireNonNull(BLOCKS).register(Pollen.PLATFORM);
        Objects.requireNonNull(FLUIDS).register(Pollen.PLATFORM);
        Objects.requireNonNull(BOATS).register(Pollen.PLATFORM);
        DispenseItemBehaviorRegistry.register((ItemLike)Blocks.f_50090_, (source, stack) -> source.m_7727_().m_8055_(new BlockPos(DispenserBlock.m_52720_((BlockSource)source))).m_60734_() == Blocks.f_50074_, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                source.m_7727_().m_7731_(new BlockPos(DispenserBlock.m_52720_((BlockSource)source)), Blocks.f_50090_.m_49966_(), 2);
                stack.m_41774_(1);
                return stack;
            }
        });
        DispenseItemBehaviorRegistry.register((ItemLike)Blocks.f_50090_, (source, stack) -> source.m_7727_().m_8055_(new BlockPos(DispenserBlock.m_52720_((BlockSource)source))).m_60734_() == Blocks.f_50268_, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                source.m_7727_().m_7731_(new BlockPos(DispenserBlock.m_52720_((BlockSource)source)), Blocks.f_50074_.m_49966_(), 2);
                stack.m_41774_(1);
                return stack;
            }
        });
        FluidBehaviorRegistry.register(TEST_TAG, new TestPollenFluidBehavior());
        FlatteningRegistry.register(Blocks.f_50268_, Blocks.f_50090_.m_49966_());
        FlatteningRegistry.register(Blocks.f_50090_, Blocks.f_50268_.m_49966_());
    }

    static void onClientPost(Platform.ModSetupContext context) {
    }

    static void onCommonPost(Platform.ModSetupContext context) {
        FlammabilityRegistry.register(Blocks.f_50090_, 200, 50);
        CompostablesRegistry.register((ItemLike)Blocks.f_49992_, 1.0f);
        FurnaceFuelRegistry.register((ItemLike)Items.f_42446_, 100);
    }

    static void onData(Platform.DataSetupContext context) {
        DataGenerator generator = context.getGenerator();
        generator.m_123914_((DataProvider)new PollinatedLootTableProvider(generator).add(LootContextParamSets.f_81411_, new TestBlockLootGenerator()));
    }

    private static <T> T create(Supplier<T> factory) {
        return !Pollen.TESTS_ENABLED ? null : (T)factory.get();
    }
}

