/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.command.PollenSuggestionProviders;
import gg.moonflower.pollen.api.command.argument.EnumArgument;
import gg.moonflower.pollen.api.config.PollinatedConfigType;
import gg.moonflower.pollen.core.command.forge.ConfigCommandImpl;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, boolean dedicated) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"showfile").then(Commands.m_82129_((String)"mod", (ArgumentType)StringArgumentType.word()).suggests(PollenSuggestionProviders.MOD_IDS).then(Commands.m_82129_((String)"type", (ArgumentType)(dedicated ? EnumArgument.enumValues(PollinatedConfigType.COMMON, PollinatedConfigType.CLIENT) : EnumArgument.enumValues(PollinatedConfigType.values()))).executes(ctx -> {
            PollinatedConfigType type;
            String modId = StringArgumentType.getString((CommandContext)ctx, (String)"mod");
            String configFileName = ConfigCommand.getConfigFileName(modId, type = EnumArgument.getEnum(PollinatedConfigType.class, ctx, "type"));
            if (configFileName != null) {
                File f = new File(configFileName);
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.pollen.config.success", new Object[]{modId, type, new TextComponent(f.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, f.getAbsolutePath())))}), false);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TranslatableComponent("commands.pollen.config.fail", new Object[]{modId, type}));
            return 0;
        })))));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getConfigFileName(String modId, PollinatedConfigType type) {
        void var1_1;
        return ConfigCommandImpl.getConfigFileName(modId, (PollinatedConfigType)var1_1);
    }
}

