/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.forge;

import com.mojang.blaze3d.vertex.VertexFormat;
import gg.moonflower.pollen.api.event.events.client.render.AddRenderLayersEvent;
import gg.moonflower.pollen.api.event.events.client.render.InitRendererEvent;
import gg.moonflower.pollen.api.event.events.registry.client.ParticleFactoryRegistryEvent;
import gg.moonflower.pollen.api.event.events.registry.client.RegisterAtlasSpriteEvent;
import gg.moonflower.pollen.api.registry.client.ShaderRegistry;
import gg.moonflower.pollen.core.Pollen;
import java.io.IOException;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod(value="pollen")
@ApiStatus.Internal
public class PollenForge {
    public PollenForge() {
        Pollen.PLATFORM.setup();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(PollenForge::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modBus.addListener(EventPriority.NORMAL, true, ColorHandlerEvent.Block.class, event -> InitRendererEvent.EVENT.invoker().initRenderer());
            modBus.addListener(PollenForge::registerParticles);
            modBus.addListener(PollenForge::registerSprites);
            modBus.addListener(event -> AddRenderLayersEvent.EVENT.invoker().addLayers(new AddRenderLayersEvent.Context(){
                final /* synthetic */ EntityRenderersEvent.AddLayers val$event;
                {
                    this.val$event = addLayers;
                }

                @Override
                public Set<String> getSkins() {
                    return this.val$event.getSkins();
                }

                @Override
                @Nullable
                public PlayerRenderer getSkin(String skinName) {
                    return (PlayerRenderer)this.val$event.getSkin(skinName);
                }

                @Override
                @Nullable
                public <T extends LivingEntity, R extends LivingEntityRenderer<T, ? extends EntityModel<T>>> R getRenderer(EntityType<? extends T> entityType) {
                    return (R)this.val$event.getRenderer(entityType);
                }

                @Override
                public EntityModelSet getEntityModels() {
                    return this.val$event.getEntityModels();
                }
            }));
            modBus.addListener(event -> {
                Logger logger = LogManager.getLogger();
                ShaderRegistry.getRegisteredShaders().forEach(entry -> {
                    try {
                        event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), (ResourceLocation)entry.getKey(), (VertexFormat)entry.getValue()), instance -> ShaderRegistry.loadShader((ResourceLocation)entry.getKey(), instance));
                    }
                    catch (IOException e) {
                        logger.error("Failed to load shader: " + entry.getKey(), (Throwable)e);
                    }
                });
            });
        });
    }

    private static void init(FMLCommonSetupEvent event) {
    }

    private static void registerSprites(TextureStitchEvent.Pre event) {
        TextureAtlas atlas = event.getAtlas();
        RegisterAtlasSpriteEvent.event(atlas.m_118330_()).invoker().registerSprites(atlas, arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }

    private static void registerParticles(ParticleFactoryRegisterEvent event) {
        final ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        ParticleFactoryRegistryEvent.EVENT.invoker().registerParticles(new ParticleFactoryRegistryEvent.Registry(){

            @Override
            public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> provider) {
                particleEngine.m_107381_(type, provider);
            }

            @Override
            public <T extends ParticleOptions> void register(ParticleType<T> type, ParticleFactoryRegistryEvent.Factory<T> factory) {
                particleEngine.m_107378_(type, factory::create);
            }
        });
    }
}

