/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.forge.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.moonflower.pollen.api.crafting.grindstone.PollenGrindstoneRecipe;
import gg.moonflower.pollen.core.forge.compat.jei.PollenJeiPlugin;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class PollenGrindstoneCategory
implements IRecipeCategory<PollenGrindstoneRecipe> {
    private static final String TOP_SLOT = "topSlot";
    private static final String BOTTOM_SLOT = "bottomSlot";
    private final IDrawable background;
    private final IDrawable icon;

    public PollenGrindstoneCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("textures/gui/container/grindstone.png"), 30, 15, 116, 56).build();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)Blocks.f_50623_));
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends PollenGrindstoneRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public RecipeType<PollenGrindstoneRecipe> getRecipeType() {
        return PollenJeiPlugin.GRINDSTONE_CATEGORY_ID;
    }

    public Component getTitle() {
        return Blocks.f_50623_.m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PollenGrindstoneRecipe recipe, IFocusGroup focus) {
        NonNullList ingredients = recipe.m_7527_();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 19, 4).addIngredients((Ingredient)ingredients.get(0))).setSlotName(TOP_SLOT);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 19, 25).addIngredients((Ingredient)ingredients.get(1))).setSlotName(BOTTOM_SLOT);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 19).addItemStack(recipe.m_8043_());
    }

    private static int getExperienceFromItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        int i = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.m_6589_()) continue;
            i += enchantment.m_6183_(integer.intValue());
        }
        return i;
    }

    public void draw(PollenGrindstoneRecipe recipe, IRecipeSlotsView view, PoseStack matrixStack, double mouseX, double mouseY) {
        int experience = recipe.getResultExperience();
        if (experience == -1) {
            Optional<Integer> topStack = view.findSlotByName(TOP_SLOT).flatMap(slot -> slot.getDisplayedIngredient(VanillaTypes.ITEM));
            Optional<Integer> bottomStack = view.findSlotByName(BOTTOM_SLOT).flatMap(slot -> slot.getDisplayedIngredient(VanillaTypes.ITEM));
            if (topStack.isEmpty() && bottomStack.isEmpty()) {
                return;
            }
            experience = topStack.map(PollenGrindstoneCategory::getExperienceFromItem).orElse(0) + bottomStack.map(PollenGrindstoneCategory::getExperienceFromItem).orElse(0);
        }
        if (experience > 0) {
            TranslatableComponent experienceString = new TranslatableComponent("gui.jei.category.pollen.grindstone.experience", new Object[]{(int)Math.ceil((double)experience / 2.0), experience});
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92889_(matrixStack, (Component)experienceString, (float)(this.background.getWidth() - font.m_92852_((FormattedText)experienceString)), 0.0f, -8355712);
        }
    }

    public boolean isHandled(PollenGrindstoneRecipe recipe) {
        return !recipe.m_5598_();
    }
}

