/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin;

import gg.moonflower.pollen.api.block.PollinatedLiquidBlock;
import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private final Set<TagKey<Fluid>> wasInFluids = new HashSet<TagKey<Fluid>>();
    @Shadow
    public Level f_19853_;
    @Shadow
    protected boolean f_19803_;
    @Shadow
    @Final
    protected Random f_19796_;

    @Shadow
    public abstract BlockPos m_142538_();

    @Shadow
    protected abstract void m_5841_();

    @Inject(method={"updateInWaterStateAndDoFluidPushing"}, at={@At(value="TAIL")}, cancellable=true)
    public void updateCustomFluids(CallbackInfoReturnable<Boolean> cir) {
        FluidBehaviorRegistry.getFluids().forEach(tag -> {
            if (FluidBehaviorRegistry.doFluidPushing((TagKey<Fluid>)tag, (Entity)this)) {
                if (this.wasInFluids.add((TagKey<Fluid>)tag) && !this.f_19803_) {
                    this.m_5841_();
                }
            } else {
                this.wasInFluids.remove(tag);
            }
        });
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    public void getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        Block block = this.f_19853_.m_8055_(this.m_142538_()).m_60734_();
        if (block instanceof PollinatedLiquidBlock) {
            cir.setReturnValue((Object)Float.valueOf(block.m_49961_()));
        }
    }

    @Inject(method={"doWaterSplashEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void doCustomFluidSplashEffect(CallbackInfo ci) {
        FluidBehaviorRegistry.getFluids().stream().filter(this.wasInFluids::contains).forEach(tag -> {
            PollenFluidBehavior behavior = Objects.requireNonNull(FluidBehaviorRegistry.get((TagKey<Fluid>)tag));
            behavior.doSplashEffect((Entity)this, this.f_19796_);
            ci.cancel();
        });
    }
}

