/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.client;

import com.mojang.authlib.GameProfile;
import gg.moonflower.pollen.api.fluid.PollenFluidBehavior;
import gg.moonflower.pollen.api.registry.FluidBehaviorRegistry;
import gg.moonflower.pollen.core.client.sound.CustomLiquidSoundInstance;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends Player {
    @Shadow
    @Final
    protected Minecraft f_108619_;
    @Shadow
    public Input f_108618_;
    @Unique
    private final Set<TagKey<Fluid>> wasInFluids = new HashSet<TagKey<Fluid>>();

    @Shadow
    public abstract void m_6858_(boolean var1);

    private LocalPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isFallFlying()Z", shift=At.Shift.BEFORE)})
    public void updateCustomFluidDescent(CallbackInfo ci) {
        if (this.m_20069_() || !this.f_108618_.f_108573_ || !this.m_6129_()) {
            return;
        }
        if (FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.f_19799_.getDouble(tag) > 0.0).anyMatch(tag -> Objects.requireNonNull(FluidBehaviorRegistry.get((TagKey<Fluid>)tag)).canDescend(this))) {
            this.m_21208_();
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;setSprinting(Z)V", ordinal=1, shift=At.Shift.AFTER)})
    public void updateCustomFluidSprint(CallbackInfo ci) {
        if (this.m_20142_() && FluidBehaviorRegistry.getFluids().stream().filter(tag -> this.f_19799_.getDouble(tag) > 0.0).anyMatch(tag -> !Objects.requireNonNull(FluidBehaviorRegistry.get((TagKey<Fluid>)tag)).canSprint(this))) {
            this.m_6858_(false);
        }
    }

    @Inject(method={"updateIsUnderwater"}, at={@At(value="TAIL")})
    public void updateCustomFluidSounds(CallbackInfoReturnable<Boolean> cir) {
        FluidBehaviorRegistry.getFluids().forEach(tag -> {
            SoundEvent ambientExit;
            PollenFluidBehavior behavior = Objects.requireNonNull(FluidBehaviorRegistry.get((TagKey<Fluid>)tag));
            boolean bl = this.wasInFluids.contains(tag);
            boolean bl2 = this.m_204029_((TagKey)tag);
            if (bl2) {
                this.wasInFluids.add((TagKey<Fluid>)tag);
            } else {
                this.wasInFluids.remove(tag);
            }
            if (!bl && bl2) {
                SoundEvent ambientEnter = behavior.getAmbientEnter(this);
                SoundEvent ambientLoop = behavior.getAmbientLoop(this);
                if (ambientEnter != null) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), ambientEnter, SoundSource.AMBIENT, 1.0f, 1.0f, false);
                }
                if (ambientLoop != null) {
                    this.f_108619_.m_91106_().m_120367_((SoundInstance)new CustomLiquidSoundInstance((LocalPlayer)this, (TagKey<Fluid>)tag, ambientLoop));
                }
            }
            if (bl && !bl2 && (ambientExit = behavior.getAmbientExit(this)) != null) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), ambientExit, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
        });
    }
}

