/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.play;

import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.core.network.play.PollenClientPlayPacketHandler;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimatedEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundSyncAnimationPacket
implements PollinatedPacket<PollenClientPlayPacketHandler> {
    private final int entityId;
    private final int animationId;
    private final int duration;

    public <T extends Entity> ClientboundSyncAnimationPacket(T entity, int duration) {
        this.entityId = entity.m_142049_();
        this.animationId = ArrayUtils.indexOf((Object[])((AnimatedEntity)entity).getAnimationStates(), (Object)((AnimatedEntity)entity).getTransitionAnimationState());
        this.duration = duration;
    }

    public ClientboundSyncAnimationPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.animationId = buf.m_130242_();
        this.duration = buf.m_130242_();
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130130_(this.animationId);
        buf.m_130130_(this.duration);
    }

    @Override
    public void processPacket(PollenClientPlayPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleSyncAnimationPacket(this, ctx);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getAnimationId() {
        return this.animationId;
    }

    public int getDuration() {
        return this.duration;
    }
}

