/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.api;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangSyntaxException;
import gg.moonflower.pollen.molangcompiler.api.object.MolangObject;
import gg.moonflower.pollen.molangcompiler.core.MolangJavaFunctionContext;
import gg.moonflower.pollen.molangcompiler.core.compiler.Dynamic2MolangExceptionType;
import gg.moonflower.pollen.molangcompiler.core.compiler.DynamicMolangExceptionType;
import gg.moonflower.pollen.molangcompiler.core.compiler.SimpleMolangExceptionType;
import gg.moonflower.pollen.molangcompiler.core.compiler.StringReader;
import gg.moonflower.pollen.molangcompiler.core.node.MolangCompoundNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangConditionalNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangConstantNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangGetVariableNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangInvokeFunctionNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangMathOperatorNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangScopeNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangSetVariableNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangThisNode;
import gg.moonflower.pollen.molangcompiler.core.object.MolangMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MolangCompiler {
    private static final SimpleMolangExceptionType UNEXPECTED_TOKEN = new SimpleMolangExceptionType("Unexpected token");
    private static final DynamicMolangExceptionType INVALID_KEYWORD = new DynamicMolangExceptionType(obj -> "Invalid keyword: " + obj);
    private static final DynamicMolangExceptionType EXPECTED = new DynamicMolangExceptionType(obj -> "Expected " + obj);
    private static final SimpleMolangExceptionType TRAILING_STATEMENT = new SimpleMolangExceptionType("Trailing statement");
    private static final Dynamic2MolangExceptionType NOT_ENOUGH_PARAMETERS = new Dynamic2MolangExceptionType((obj, obj2) -> "Not enough parameters. Expected at least " + obj + ", got " + obj2);
    private static final Dynamic2MolangExceptionType TOO_MANY_PARAMETERS = new Dynamic2MolangExceptionType((obj, obj2) -> "Too many parameters. Expected at most " + obj + ", got " + obj2);
    public static final int REDUCE_FLAG = 1;
    private static final int CHECK_THIS_FLAG = 2;
    private static final int CHECK_VARIABLE_FLAG = 4;
    private static final int CHECK_METHOD_FLAG = 8;
    private static final int CHECK_OPERATORS_FLAG = 16;
    private static final int CHECK_SCOPE_FLAG = 32;
    private static final MolangEnvironment ENVIRONMENT = new CompileEnvironment();
    private static final List<Character> MATH_OPERATORS = Arrays.asList(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('+'), Character.valueOf('-'));

    public static MolangExpression compile(String input) throws MolangSyntaxException {
        return MolangCompiler.compile(input, 1);
    }

    public static MolangExpression compile(String input, int flags) throws MolangSyntaxException {
        if (input.isEmpty()) {
            throw UNEXPECTED_TOKEN.create();
        }
        if (input.contains(".")) {
            flags |= 4;
            if (input.contains("(")) {
                flags |= 0x18;
            }
        }
        if (input.contains("this")) {
            flags |= 2;
        }
        if (!MolangCompiler.checkFlag(flags, 16)) {
            for (char operator : MATH_OPERATORS) {
                if (input.indexOf(operator) == -1) continue;
                flags |= 0x10;
                break;
            }
        }
        return MolangCompiler.parseGroup(input, flags, true);
    }

    private static MolangExpression parseGroup(String input, int flags, boolean strictSyntax) throws MolangSyntaxException {
        ArrayList<MolangExpression> expressions = new ArrayList<MolangExpression>();
        StringReader reader = new StringReader(input);
        reader.skipWhitespace();
        if (!reader.canRead()) {
            throw UNEXPECTED_TOKEN.create();
        }
        if ((strictSyntax || !input.contains("return")) && input.chars().filter(c -> c == 59).count() <= 1L) {
            return MolangCompiler.parseExpression(new StringReader(input.replaceAll(";", "")), flags, true, true);
        }
        int start = 0;
        int scopeStart = 0;
        int scope = 0;
        boolean startScope = false;
        while (reader.canRead()) {
            if (reader.peek() == '{') {
                if (scopeStart == reader.getCursor()) {
                    startScope = true;
                }
                ++scope;
                flags |= 0x20;
            } else if (reader.peek() == '}') {
                if (--scope < 0) {
                    throw TRAILING_STATEMENT.createWithContext(reader);
                }
                if (scope == 0 && startScope) {
                    startScope = false;
                    reader.skip();
                    expressions.add(MolangCompiler.parseExpression(new StringReader(input.substring(start, reader.getCursor())), flags, false, true));
                    start = reader.getCursor();
                }
            } else if (scope == 0 && reader.peek() == ';') {
                expressions.add(MolangCompiler.parseExpression(new StringReader(input.substring(start, reader.getCursor())), flags, false, true));
                start = reader.getCursor() + 1;
                reader.skip();
                reader.skipWhitespace();
                scopeStart = reader.getCursor();
                continue;
            }
            reader.skip();
            reader.skipWhitespace();
        }
        if (expressions.isEmpty()) {
            if (strictSyntax) {
                throw UNEXPECTED_TOKEN.createWithContext(reader);
            }
            return MolangCompiler.parseExpression(new StringReader(input.replaceAll(";", "")), flags, false, true);
        }
        return expressions.size() == 1 ? (MolangExpression)expressions.get(0) : new MolangCompoundNode(expressions.toArray(new MolangExpression[0]));
    }

    private static MolangExpression parseExpression(StringReader reader, int flags, boolean simple, boolean allowMath) throws MolangSyntaxException {
        reader.skipWhitespace();
        if (!reader.canRead()) {
            throw UNEXPECTED_TOKEN.createWithContext(reader);
        }
        if (MolangCompiler.checkFlag(flags, 32) && reader.peek() == '{') {
            reader.skip();
            int start = reader.getCursor();
            int scope = 1;
            while (reader.canRead()) {
                if (reader.peek() == '{') {
                    ++scope;
                } else if (reader.peek() == '}') {
                    if (--scope < 0) break;
                    if (scope == 0) {
                        reader.skip();
                        return new MolangScopeNode(MolangCompiler.parseGroup(reader.getString().substring(start, reader.getCursor() - 1), flags, false));
                    }
                }
                reader.skip();
            }
            throw TRAILING_STATEMENT.createWithContext(reader);
        }
        if (reader.getRemaining().startsWith("return")) {
            reader.skip(6);
            if (simple) {
                throw UNEXPECTED_TOKEN.createWithContext(reader);
            }
            MolangExpression expression = MolangCompiler.parseExpression(reader, flags, true, allowMath);
            if (reader.canRead()) {
                throw TRAILING_STATEMENT.createWithContext(reader);
            }
            return expression;
        }
        if (MolangCompiler.checkFlag(flags, 16) && !reader.getRemaining().contains("=") && !reader.getRemaining().contains("?") && !reader.getRemaining().contains(":") && allowMath) {
            for (char operator : MATH_OPERATORS) {
                if (!reader.getRemaining().chars().anyMatch(a -> a == operator)) continue;
                return MolangCompiler.compute(reader, flags);
            }
        }
        String[] currentKeyword = MolangCompiler.parseKeyword(reader, simple);
        String fullWord = currentKeyword[0] + (currentKeyword.length > 1 ? "." + currentKeyword[1] : "");
        if (MolangCompiler.checkFlag(flags, 2) && "this".equals(fullWord)) {
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() != '?' && reader.peek() != ':' && !MATH_OPERATORS.contains(Character.valueOf(reader.peek()))) {
                throw TRAILING_STATEMENT.createWithContext(reader);
            }
            return MolangCompiler.parseCondition(reader, new MolangThisNode(), flags, allowMath);
        }
        if ("true".equals(fullWord) || "false".equals(fullWord)) {
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() != '?' && reader.peek() != ':' && !MATH_OPERATORS.contains(Character.valueOf(reader.peek()))) {
                throw TRAILING_STATEMENT.createWithContext(reader);
            }
            return MolangCompiler.parseCondition(reader, MolangExpression.of("true".equals(fullWord)), flags, allowMath);
        }
        if (MolangCompiler.isNumber(fullWord)) {
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() != '?' && reader.peek() != ':' && !MATH_OPERATORS.contains(Character.valueOf(reader.peek()))) {
                throw TRAILING_STATEMENT.createWithContext(reader);
            }
            return MolangCompiler.parseCondition(reader, MolangExpression.of(Float.parseFloat(fullWord)), flags, allowMath);
        }
        if (currentKeyword.length <= 1 || currentKeyword[0].isEmpty()) {
            throw UNEXPECTED_TOKEN.createWithContext(reader);
        }
        if (MolangCompiler.isNumber(currentKeyword[0].substring(0, 1))) {
            throw UNEXPECTED_TOKEN.createWithContext(reader);
        }
        if (MolangCompiler.checkFlag(flags, 8) && reader.canRead() && reader.peek() == '(') {
            int start = reader.getCursor();
            reader.skip();
            MolangExpression[] parameters = null;
            int parentheses = 0;
            while (reader.canRead() && start != -1) {
                if (reader.peek() == '(') {
                    ++parentheses;
                }
                if (reader.peek() == ')') {
                    if (parentheses > 0) {
                        --parentheses;
                        reader.skip();
                        continue;
                    }
                    if (reader.getCursor() == start) {
                        parameters = new MolangExpression[]{};
                    } else {
                        String[] parameterStrings = reader.getRead().substring(start).split(",");
                        parameters = new MolangExpression[parameterStrings.length];
                        for (int i = 0; i < parameterStrings.length; ++i) {
                            parameters[i] = MolangCompiler.parseExpression(new StringReader(parameterStrings[i]), flags, true, true);
                        }
                    }
                    start = -1;
                }
                reader.skip();
            }
            if (start != -1) {
                throw EXPECTED.createWithContext(reader, Character.valueOf(')'));
            }
            reader.skipWhitespace();
            return MolangCompiler.parseCondition(reader, MolangCompiler.parseMethod(currentKeyword, parameters, flags), flags, allowMath);
        }
        if (MolangCompiler.checkFlag(flags, 4)) {
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() == '=') {
                reader.skip();
                MolangExpression expression = MolangCompiler.parseExpression(reader, flags, true, allowMath);
                return new MolangSetVariableNode(currentKeyword[0], currentKeyword[1], expression);
            }
            if ("math".equalsIgnoreCase(currentKeyword[0])) {
                MolangMath.MathFunction function = MolangMath.MathFunction.byName(currentKeyword[1]);
                if (function == null || function.getOp() != null) {
                    throw INVALID_KEYWORD.create(currentKeyword[1]);
                }
                if (MolangCompiler.checkFlag(flags, 1)) {
                    return function.getExpression();
                }
            }
            return MolangCompiler.parseCondition(reader, new MolangGetVariableNode(currentKeyword[0], currentKeyword[1]), flags, allowMath);
        }
        throw TRAILING_STATEMENT.createWithContext(reader);
    }

    private static MolangExpression parseCondition(StringReader reader, MolangExpression expression, int flags, boolean allowMath) throws MolangSyntaxException {
        if (reader.canRead() && reader.peek() == '?') {
            reader.skip();
            reader.skipWhitespace();
            int start = reader.getCursor();
            while (reader.canRead() && reader.peek() != ':') {
                reader.skip();
            }
            if (!reader.canRead()) {
                throw TRAILING_STATEMENT.createWithContext(reader);
            }
            MolangExpression first = MolangCompiler.parseExpression(new StringReader(reader.getRead().substring(start)), flags, true, allowMath);
            if (!reader.canRead()) {
                throw TRAILING_STATEMENT.createWithContext(reader);
            }
            reader.skip();
            MolangExpression branch = MolangCompiler.parseExpression(reader, flags, true, allowMath);
            MolangConditionalNode condition = new MolangConditionalNode(expression, first, branch);
            if (MolangCompiler.checkFlag(flags, 1) && expression instanceof MolangConstantNode) {
                try {
                    return (double)expression.resolve(ENVIRONMENT) != 0.0 ? first : branch;
                }
                catch (MolangException e) {
                    e.printStackTrace();
                }
            }
            return condition;
        }
        return expression;
    }

    private static String[] parseKeyword(StringReader reader, boolean simple) throws MolangSyntaxException {
        LinkedList<String> keywords = new LinkedList<String>();
        int start = reader.getCursor();
        while (reader.canRead() && MolangCompiler.isValidKeywordChar(reader.peek())) {
            if (reader.peek() == '.' && keywords.isEmpty()) {
                keywords.add(reader.getRead().substring(start));
                reader.skip();
                start = reader.getCursor();
            }
            if (!reader.canRead()) {
                throw UNEXPECTED_TOKEN.createWithContext(reader);
            }
            reader.skip();
        }
        if (start < reader.getCursor()) {
            keywords.add(reader.getRead().substring(start));
        }
        if (keywords.stream().allMatch(String::isEmpty)) {
            if (simple) {
                return new String[0];
            }
            throw UNEXPECTED_TOKEN.createWithContext(reader);
        }
        return keywords.toArray(new String[0]);
    }

    private static boolean hasMethod(StringReader reader) {
        int start = reader.getCursor();
        int parenthesis = -1;
        while (reader.canRead() && (MolangCompiler.isValidKeywordChar(reader.peek()) || reader.peek() == '(' || reader.peek() == ')' || parenthesis >= 0)) {
            if (reader.peek() == '(') {
                if (parenthesis == -1) {
                    parenthesis = 0;
                }
                ++parenthesis;
            }
            if (reader.peek() == ')') {
                if (parenthesis == 0) break;
                --parenthesis;
            }
            if (!reader.canRead()) {
                reader.setCursor(start);
                return false;
            }
            reader.skip();
        }
        boolean success = start < reader.getCursor();
        reader.setCursor(start);
        return success && parenthesis == 0;
    }

    private static MolangExpression parseMethod(String[] methodName, MolangExpression[] parameters, int flags) throws MolangSyntaxException {
        if ("math".equalsIgnoreCase(methodName[0])) {
            MolangMath.MathFunction function = MolangMath.MathFunction.byName(methodName[1] + "$" + parameters.length);
            if (function == null && (function = MolangMath.MathFunction.byName(methodName[1])) == null) {
                throw INVALID_KEYWORD.create(methodName[1]);
            }
            if (function.getOp() == null) {
                throw UNEXPECTED_TOKEN.create();
            }
            if (function.getParameters() >= 0) {
                if (parameters.length < function.getParameters()) {
                    throw NOT_ENOUGH_PARAMETERS.create(function.getParameters(), parameters.length);
                }
                if (parameters.length > function.getParameters()) {
                    throw TOO_MANY_PARAMETERS.create(function.getParameters(), parameters.length);
                }
            }
            if (MolangCompiler.checkFlag(flags, 1)) {
                boolean reduceFunction = true;
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i] instanceof MolangConstantNode) continue;
                    try {
                        parameters[i] = MolangExpression.of(parameters[i].resolve(ENVIRONMENT));
                        continue;
                    }
                    catch (MolangException e) {
                        reduceFunction = false;
                    }
                }
                if (reduceFunction) {
                    try {
                        return MolangExpression.of(function.getOp().resolve(new MolangJavaFunctionContext(ENVIRONMENT, parameters)));
                    }
                    catch (MolangException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return new MolangInvokeFunctionNode(methodName[0], methodName[1], parameters);
    }

    private static MolangExpression compute(final StringReader reader, final int flags) throws MolangSyntaxException {
        return new Object(){
            private boolean canReduce;
            {
                this.canReduce = MolangCompiler.checkFlag(flags, 1);
            }

            boolean accept(int charToEat) {
                reader.skipWhitespace();
                if (reader.canRead() && reader.peek() == charToEat) {
                    reader.skip();
                    return true;
                }
                return false;
            }

            MolangExpression parse() throws MolangSyntaxException {
                reader.skipWhitespace();
                MolangExpression x = this.parseExpression();
                reader.skipWhitespace();
                if (reader.canRead()) {
                    throw TRAILING_STATEMENT.createWithContext(reader);
                }
                if (!this.canReduce) {
                    return x;
                }
                try {
                    return MolangExpression.of(x.resolve(ENVIRONMENT));
                }
                catch (MolangException e) {
                    e.printStackTrace();
                    return x;
                }
            }

            MolangExpression parseExpression() throws MolangSyntaxException {
                MolangExpression x = this.parseTerm();
                while (true) {
                    if (this.accept(43)) {
                        x = new MolangMathOperatorNode(MolangMathOperatorNode.MathOperation.ADD, x, this.parseTerm());
                        continue;
                    }
                    if (!this.accept(45)) break;
                    x = new MolangMathOperatorNode(MolangMathOperatorNode.MathOperation.SUBTRACT, x, this.parseTerm());
                }
                return x;
            }

            MolangExpression parseTerm() throws MolangSyntaxException {
                MolangExpression x = this.parseFactor();
                while (true) {
                    boolean accept;
                    if (accept = this.accept(42)) {
                        x = new MolangMathOperatorNode(MolangMathOperatorNode.MathOperation.MULTIPLY, x, this.parseFactor());
                        continue;
                    }
                    if (!this.accept(47)) break;
                    x = new MolangMathOperatorNode(MolangMathOperatorNode.MathOperation.DIVIDE, x, this.parseFactor());
                }
                return x;
            }

            MolangExpression parseFactor() throws MolangSyntaxException {
                if (this.accept(43)) {
                    return this.parseFactor();
                }
                if (this.accept(45)) {
                    return new MolangMathOperatorNode(MolangMathOperatorNode.MathOperation.MULTIPLY, this.parseFactor(), MolangExpression.of(-1.0f));
                }
                if (this.accept(40)) {
                    MolangExpression expression = this.parseExpression();
                    this.accept(41);
                    return expression;
                }
                reader.skipWhitespace();
                int start = reader.getCursor();
                int parentheses = 0;
                boolean hasMethod = MolangCompiler.hasMethod(reader);
                while (reader.canRead() && (Character.isWhitespace(reader.peek()) || !MATH_OPERATORS.contains(Character.valueOf(reader.peek())) || hasMethod)) {
                    if (reader.peek() == '(') {
                        ++parentheses;
                    }
                    if (reader.peek() == ')' && hasMethod && --parentheses == 0) {
                        reader.skip();
                        break;
                    }
                    reader.skip();
                }
                MolangExpression expression = MolangCompiler.parseExpression(new StringReader(reader.getRead().substring(start)), flags, true, false);
                if (!MolangCompiler.checkFlag(flags, 1)) {
                    return expression;
                }
                if (this.canReduce && (expression instanceof MolangSetVariableNode || expression instanceof MolangInvokeFunctionNode || expression instanceof MolangGetVariableNode || expression instanceof MolangThisNode)) {
                    this.canReduce = false;
                }
                return expression;
            }
        }.parse();
    }

    private static boolean checkFlag(int flags, int flag) {
        return (flags & flag) > 0;
    }

    private static boolean isValidKeywordChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '.';
    }

    private static boolean isNumber(String input) {
        if (input.isEmpty()) {
            return false;
        }
        if (input.charAt(input.length() - 1) == '.') {
            return false;
        }
        if (input.charAt(0) == '-') {
            if (input.length() == 1) {
                return false;
            }
            return MolangCompiler.withDecimalsParsing(input, 1);
        }
        return MolangCompiler.withDecimalsParsing(input, 0);
    }

    private static boolean withDecimalsParsing(String str, int beginIndex) {
        int decimalPoints = 0;
        for (int i = beginIndex; i < str.length(); ++i) {
            boolean isDecimalPoint;
            boolean bl = isDecimalPoint = str.charAt(i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (isDecimalPoint || Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static class CompileEnvironment
    implements MolangEnvironment {
        private CompileEnvironment() {
        }

        @Override
        public void loadParameter(int index, MolangExpression expression) throws MolangException {
            throw new MolangException("Invalid Call");
        }

        @Override
        public void clearParameters() throws MolangException {
            throw new MolangException("Invalid Call");
        }

        @Override
        public float getThis() throws MolangException {
            throw new MolangException("Invalid Call");
        }

        @Override
        public MolangObject get(String name) throws MolangException {
            throw new MolangException("Invalid Call");
        }

        @Override
        public MolangExpression getParameter(int parameter) throws MolangException {
            throw new MolangException("Invalid Call");
        }

        @Override
        public boolean hasParameter(int parameter) throws MolangException {
            throw new MolangException("Invalid Call");
        }
    }
}

