/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.api.exception;

import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import org.jetbrains.annotations.Nullable;

public class MolangSyntaxException
extends MolangException {
    public static final int CONTEXT_AMOUNT = 64;
    private final String message;
    private final String input;
    private final int cursor;

    public MolangSyntaxException(String message) {
        super(message);
        this.message = message;
        this.input = null;
        this.cursor = -1;
    }

    public MolangSyntaxException(String message, String input, int cursor) {
        super(message);
        this.message = message;
        this.input = input;
        this.cursor = cursor;
    }

    @Override
    public String getMessage() {
        String message = this.message;
        String context = this.getContext();
        if (context != null) {
            message = message + " at position " + this.cursor + ": " + context;
        }
        return message;
    }

    public String getRawMessage() {
        return this.message;
    }

    public String getContext() {
        if (this.input == null || this.cursor < 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int cursor = Math.min(this.input.length(), this.cursor);
        if (cursor > 64) {
            builder.append("...");
        }
        builder.append(this.input, Math.max(0, cursor - 64), cursor);
        builder.append("<--[HERE]");
        return builder.toString();
    }

    @Nullable
    public String getInput() {
        return this.input;
    }

    public int getCursor() {
        return this.cursor;
    }
}

