/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.core.node;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MolangMathOperatorNode
implements MolangExpression {
    private final MathOperation operation;
    private final MolangExpression a;
    private final MolangExpression b;

    public MolangMathOperatorNode(MathOperation operation, MolangExpression a, MolangExpression b) {
        this.operation = operation;
        this.a = a;
        this.b = b;
    }

    @Override
    public float resolve(MolangEnvironment environment) throws MolangException {
        return this.operation.op.apply(this.a, this.b, environment);
    }

    public String toString() {
        return "(" + this.a + " " + this.operation.sign + " " + this.b + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MolangMathOperatorNode that = (MolangMathOperatorNode)o;
        return this.operation == that.operation && this.a.equals(that.a) && this.b.equals(that.b);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.a, this.b});
    }

    private static interface MathOp {
        public float apply(MolangExpression var1, MolangExpression var2, MolangEnvironment var3) throws MolangException;
    }

    public static enum MathOperation {
        MULTIPLY('*', (a, b, environment) -> a.resolve(environment) * b.resolve(environment)),
        DIVIDE('/', (a, b, environment) -> {
            float second = b.resolve(environment);
            if (second == 0.0f) {
                return 0.0f;
            }
            return a.resolve(environment) / second;
        }),
        ADD('+', (a, b, environment) -> a.resolve(environment) + b.resolve(environment)),
        SUBTRACT('-', (a, b, environment) -> a.resolve(environment) - b.resolve(environment));

        private final char sign;
        private final MathOp op;

        private MathOperation(char sign, MathOp op) {
            this.sign = sign;
            this.op = op;
        }
    }
}

