/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.core.object;

import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.molangcompiler.api.object.MolangLibrary;
import gg.moonflower.pollen.molangcompiler.core.object.MolangFunction;
import java.util.Locale;
import java.util.Random;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MolangMath
extends MolangLibrary {
    private static final Random RNG = new Random();

    @Override
    protected void populate(BiConsumer<String, MolangExpression> consumer) {
        for (MathFunction function : MathFunction.values()) {
            consumer.accept(function.functionName, function.expression);
        }
    }

    @Override
    protected String getName() {
        return "MoLang Math";
    }

    public static enum MathFunction {
        ABS(1, parameters -> Math.abs(parameters.resolve(0))),
        ACOS(1, parameters -> (float)Math.acos(parameters.resolve(0))),
        ASIN(1, parameters -> (float)Math.asin(parameters.resolve(0))),
        ATAN(1, parameters -> (float)Math.atan(parameters.resolve(0))),
        ATAN2(2, parameters -> (float)Math.atan2(parameters.resolve(0), parameters.resolve(1))),
        CEIL(1, parameters -> (float)Math.ceil(parameters.resolve(0))),
        CLAMP(3, parameters -> {
            float min;
            float value = parameters.resolve(0);
            if (value <= (min = parameters.resolve(1))) {
                return min;
            }
            return Math.min(value, parameters.resolve(2));
        }),
        COS(1, parameters -> (float)Math.cos((double)parameters.resolve(0) * Math.PI / 180.0)),
        DIE_ROLL(3, parameters -> {
            float max;
            int count = (int)parameters.resolve(0);
            if (count <= 0) {
                return 0.0f;
            }
            float min = parameters.resolve(1);
            if (min == (max = parameters.resolve(2))) {
                return min * (float)count;
            }
            float sum = 0.0f;
            for (int i = 0; i < count; ++i) {
                sum += min + RNG.nextFloat() * (max - min);
            }
            return sum;
        }),
        DIE_ROLL_INTEGER(3, parameters -> {
            int max;
            int count = (int)parameters.resolve(0);
            if (count <= 0) {
                return 0.0f;
            }
            int min = (int)parameters.resolve(1);
            if (min == (max = (int)parameters.resolve(2))) {
                return min * count;
            }
            if (min > max) {
                throw new MolangException("Invalid random range: " + min + " to " + max);
            }
            int sum = 0;
            for (int i = 0; i < count; ++i) {
                sum += max + RNG.nextInt(min - max);
            }
            return sum;
        }),
        EXP(1, parameters -> (float)Math.exp(parameters.resolve(0))),
        FLOOR(1, parameters -> (float)Math.floor(parameters.resolve(0))),
        HERMITE_BLEND(1, parameters -> {
            float x = parameters.resolve(0);
            return 3.0f * x * x - 2.0f * x * x * x;
        }),
        LERP(3, parameters -> {
            float pct = parameters.resolve(2);
            if (pct <= 0.0f) {
                return parameters.resolve(0);
            }
            if (pct >= 1.0f) {
                return parameters.resolve(1);
            }
            float min = parameters.resolve(0);
            return min + (parameters.resolve(1) - min) * pct;
        }),
        LERPROTATE(3, parameters -> {
            float difference;
            float pct = parameters.resolve(2);
            if (pct <= 0.0f) {
                return parameters.resolve(0);
            }
            if (pct >= 1.0f) {
                return parameters.resolve(1);
            }
            float min = parameters.resolve(0);
            float max = parameters.resolve(1);
            for (difference = max - min; difference < -180.0f; difference += 360.0f) {
            }
            while (difference >= 180.0f) {
                difference -= 360.0f;
            }
            return min + difference * pct;
        }),
        LN(1, parameters -> (float)Math.log(parameters.resolve(0))),
        MAX(2, parameters -> Math.max(parameters.resolve(0), parameters.resolve(1))),
        MIN(2, parameters -> Math.min(parameters.resolve(0), parameters.resolve(1))),
        MOD(2, parameters -> parameters.resolve(0) % parameters.resolve(1)),
        PI(MolangExpression.of((float)Math.PI)),
        POW(2, parameters -> (float)Math.pow(parameters.resolve(0), parameters.resolve(1))),
        RANDOM(2, parameters -> {
            float max;
            float min = parameters.resolve(0);
            if (min > (max = parameters.resolve(1))) {
                throw new MolangException("Invalid random range: " + min + " to " + max);
            }
            return min + RNG.nextFloat() * (max - min);
        }),
        RANDOM_INTEGER(2, parameters -> {
            int max;
            int min = (int)parameters.resolve(0);
            if (min > (max = (int)parameters.resolve(1))) {
                throw new MolangException("Invalid random range: " + min + " to " + max);
            }
            return min + RNG.nextInt(max - min);
        }),
        ROUND(1, parameters -> Math.round(parameters.resolve(0))),
        SIN(1, parameters -> (float)Math.sin((double)parameters.resolve(0) * Math.PI / 180.0)),
        SQRT(1, parameters -> (float)Math.sqrt(parameters.resolve(0))),
        TRUNC(1, parameters -> (int)parameters.resolve(0)),
        TRIANGLE_WAVE(2, parameters -> {
            float x = parameters.resolve(0);
            float period = parameters.resolve(1);
            return (Math.abs(x % period - period * 0.5f) - period * 0.25f) / (period * 0.25f);
        });

        private final int parameters;
        private final String functionName;
        private final MolangExpression expression;
        private final MolangJavaFunction op;

        private MathFunction(int parameters, MolangJavaFunction op) {
            this.parameters = parameters;
            this.functionName = this.name().toLowerCase(Locale.ROOT) + "$" + parameters;
            this.expression = new MolangFunction(parameters, op);
            this.op = op;
        }

        private MathFunction(MolangExpression value) {
            this.parameters = 0;
            this.functionName = this.name().toLowerCase(Locale.ROOT);
            this.expression = value;
            this.op = null;
        }

        public int getParameters() {
            return this.parameters;
        }

        public MolangExpression getExpression() {
            return this.expression;
        }

        @Nullable
        public MolangJavaFunction getOp() {
            return this.op;
        }

        @Nullable
        public static MathFunction byName(String name) {
            for (MathFunction function : MathFunction.values()) {
                if (!function.functionName.equals(name)) continue;
                return function;
            }
            return null;
        }
    }
}

