/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.core.object;

import gg.moonflower.pollen.molangcompiler.api.MolangExpression;
import gg.moonflower.pollen.molangcompiler.api.object.MolangObject;
import gg.moonflower.pollen.molangcompiler.core.object.MolangFunction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class MolangVariableStorage
implements MolangObject {
    private final Map<String, MolangExpression> storage = new HashMap<String, MolangExpression>();
    private final boolean allowMethods;

    public MolangVariableStorage(boolean allowMethods) {
        this.allowMethods = allowMethods;
    }

    protected Map<String, MolangExpression> getStorage() {
        return this.storage;
    }

    @Override
    public void set(String name, MolangExpression value) {
        if (value.equals(MolangExpression.ZERO)) {
            this.getStorage().remove(name);
            return;
        }
        if (!this.allowMethods && value instanceof MolangFunction) {
            throw new IllegalStateException("Cannot set functions on objects that do not allow functions");
        }
        this.getStorage().put(name, value);
    }

    @Override
    public MolangExpression get(String name) {
        return this.getStorage().getOrDefault(name, MolangExpression.ZERO);
    }

    @Override
    public boolean has(String name) {
        return this.getStorage().containsKey(name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MoLang Object\n");
        for (Map.Entry<String, MolangExpression> entry : this.getStorage().entrySet()) {
            builder.append('\t').append(entry.getKey());
            if (entry.getValue() instanceof MolangFunction) {
                builder.append("()");
            } else {
                builder.append('=').append(entry.getValue());
            }
            builder.append('\n');
        }
        return builder.toString();
    }
}

