/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gg.moonflower.pollen.molangcompiler.api.MolangRuntime;
import gg.moonflower.pollen.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModel;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelRenderer;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import java.util.Arrays;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AnimatedGeometryEntityModel<T extends Entity>
extends EntityModel<T> {
    private final ResourceLocation model;
    private ResourceLocation texture;
    private ResourceLocation[] animations;
    private float[] animationWeights;
    private MolangVariableProvider variableProvider;

    public AnimatedGeometryEntityModel(ResourceLocation model) {
        this.model = model;
        this.texture = null;
        this.animations = new ResourceLocation[0];
        this.animationWeights = new float[0];
        this.variableProvider = null;
    }

    private MolangRuntime.Builder createRuntime(T entity, float limbSwing, float limbSwingAmount, float yaw, float pitch) {
        float partialTicks = Minecraft.m_91087_().m_91296_();
        MolangRuntime.Builder builder = MolangRuntime.runtime();
        if (((Entity)entity).f_19853_ instanceof ClientLevel) {
            builder.setQuery("actor_count", () -> Float.valueOf(((ClientLevel)entity.f_19853_).m_104813_()));
        }
        builder.setQuery("time_of_day", () -> Float.valueOf(entity.f_19853_.m_46942_(partialTicks) / 24000.0f));
        builder.setQuery("day", () -> Float.valueOf(entity.f_19853_.m_46468_() / 24000L + 1L));
        builder.setQuery("moon_phase", () -> Float.valueOf(entity.f_19853_.m_46941_()));
        builder.setQuery("moon_brightness", () -> Float.valueOf(entity.f_19853_.m_46940_()));
        builder.setQuery("is_on_ground", entity.m_20096_() ? 1.0f : 0.0f);
        builder.setQuery("is_in_water", entity.m_20069_() ? 1.0f : 0.0f);
        builder.setQuery("is_in_water_or_rain", entity.m_20070_() ? 1.0f : 0.0f);
        builder.setQuery("is_in_contact_with_water", entity.m_20071_() ? 1.0f : 0.0f);
        builder.setQuery("is_moving", () -> Float.valueOf(entity.m_20184_().m_82556_() > 1.0E-7 ? 1.0f : 0.0f));
        builder.setQuery("is_alive", entity.m_6084_() ? 1.0f : 0.0f);
        builder.setQuery("is_fire_immune", entity.m_5825_() ? 1.0f : 0.0f);
        builder.setQuery("is_on_fire", entity.m_6060_() ? 1.0f : 0.0f);
        builder.setQuery("is_first_person", entity == Minecraft.m_91087_().m_91288_() && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON ? 1.0f : 0.0f);
        builder.setQuery("is_invisible", entity.m_20145_() ? 1.0f : 0.0f);
        builder.setQuery("is_ghost", entity.m_5833_() ? 1.0f : 0.0f);
        builder.setQuery("ground_speed", () -> {
            Vec3 velocity = entity.m_20184_();
            return Float.valueOf(Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_))));
        });
        if (entity instanceof LivingEntity) {
            builder.setQuery("modified_move_speed", ((LivingEntity)entity).m_6113_());
        }
        builder.setQuery("modified_distance_moved", ((Entity)entity).f_19788_);
        builder.setQuery("vertical_speed", (float)entity.m_20184_().m_7098_());
        builder.setQuery("head_x_rotation", pitch);
        builder.setQuery("head_y_rotation", yaw);
        if (entity instanceof LivingEntity) {
            builder.setQuery("body_y_rotation", () -> Float.valueOf(Mth.m_14179_((float)partialTicks, (float)((LivingEntity)entity).f_20884_, (float)((LivingEntity)entity).f_20883_)));
        }
        builder.setQuery("head_x_rotation_speed", () -> Float.valueOf(entity.m_5686_(partialTicks) - entity.m_5686_((float)((double)partialTicks - 0.1))));
        builder.setQuery("head_y_rotation_speed", () -> Float.valueOf(entity.m_5675_(partialTicks) - entity.m_5675_((float)((double)partialTicks - 0.1))));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            builder.setQuery("health", livingEntity.m_21223_());
            builder.setQuery("max_health", livingEntity.m_21233_());
            builder.setQuery("is_baby", livingEntity.m_6162_() ? 1.0f : 0.0f);
        }
        builder.setQuery("distance_from_camera", () -> Float.valueOf((float)Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_())));
        builder.setQuery("camera_distance_range_lerp", 2, context -> {
            float second;
            float first = context.resolve(0);
            if (first == (second = context.resolve(1))) {
                return 1.0f;
            }
            float smaller = Math.min(first, second);
            float larger = Math.max(first, second);
            double distance = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_());
            if (distance <= (double)smaller) {
                return smaller;
            }
            if (distance >= (double)larger) {
                return larger;
            }
            return (float)((distance - (double)smaller) / (double)(larger - smaller));
        });
        builder.setQuery("lod_index", -1, context -> {
            if (context.getParameters() <= 0) {
                return 0.0f;
            }
            double distance = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_());
            for (int i = 0; i < context.getParameters(); ++i) {
                if (!(distance < (double)context.resolve(0))) continue;
                return i;
            }
            return context.getParameters() - 1;
        });
        builder.setQuery("position", 1, context -> {
            int index = (int)context.resolve(0);
            if (index < 0 || index >= 3) {
                throw new MolangException("Invalid argument for position(): " + index);
            }
            return (float)(index == 0 ? entity.m_20165_((double)partialTicks) : (index == 1 ? entity.m_20227_((double)partialTicks) : entity.m_20246_((double)partialTicks)));
        });
        builder.setQuery("position_delta", 1, context -> {
            int index = (int)context.resolve(0);
            if (index < 0 || index >= 3) {
                throw new MolangException("Invalid argument for position(): " + index);
            }
            return (float)(index == 0 ? entity.m_20184_().m_7096_() : (index == 1 ? entity.m_20184_().m_7098_() : entity.m_20184_().m_7094_()));
        });
        builder.setQuery("limb_swing", limbSwing);
        builder.setQuery("limb_swing_amount", limbSwingAmount);
        return builder;
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float animationTicks, float netHeadYaw, float headPitch) {
        GeometryModel model = this.getModel();
        model.resetTransformation();
        if (model instanceof AnimatedModel && this.animations.length > 0) {
            AnimationData[] animationData = this.getAnimations();
            if (animationData.length == 0) {
                return;
            }
            ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
            profiler.m_6180_("createMolangRuntime");
            MolangRuntime.Builder builder = this.createRuntime(entity, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
            if (entity instanceof MolangVariableProvider) {
                builder.setVariables((MolangVariableProvider)entity);
            }
            if (this.variableProvider != null) {
                builder.setVariables(this.variableProvider);
            }
            profiler.m_6182_("applyMolangAnimation");
            ((AnimatedModel)((Object)model)).applyAnimations(animationTicks / 20.0f, builder, this.animationWeights, animationData);
            profiler.m_7238_();
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderToBuffer(matrixStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderToBuffer(PoseStack matrixStack, MultiBufferSource source, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, (double)1.501f, 0.0);
        GeometryModelRenderer.render(this.getModel(), this.texture, source, matrixStack, packedLight, packedOverlay, red, green, blue, alpha);
        matrixStack.m_85849_();
    }

    public GeometryModel getModel() {
        return GeometryModelManager.getModel(this.model);
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(@Nullable ResourceLocation texture) {
        this.texture = texture;
    }

    public ResourceLocation[] getAnimationNames() {
        return this.animations;
    }

    public AnimationData[] getAnimations() {
        return (AnimationData[])Arrays.stream(this.animations).map(AnimationManager::getAnimation).filter(animation -> animation != AnimationData.EMPTY).toArray(AnimationData[]::new);
    }

    public void setAnimations(ResourceLocation ... animations) {
        this.animations = animations;
    }

    public void setAnimationWeights(float[] animationWeights) {
        this.animationWeights = animationWeights;
    }

    public void setVariableProvider(@Nullable MolangVariableProvider variableProvider) {
        this.variableProvider = variableProvider;
    }
}

