/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedGeometryEntityModel;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationEffectHandler;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;

public abstract class GeometryEntityRenderer<T extends Mob>
extends MobRenderer<T, AnimatedGeometryEntityModel<T>> {
    public GeometryEntityRenderer(EntityRendererProvider.Context context, ResourceLocation model, float shadowSize) {
        super(context, new AnimatedGeometryEntityModel(model), shadowSize);
    }

    protected abstract float getBob(T var1, float var2);

    @Nullable
    protected AnimationEffectHandler getEffectHandler(T entity) {
        return null;
    }

    protected void setupRotations(T entity, PoseStack matrixStack, float ticksExisted, float rotY, float partialTicks) {
        super.m_7523_(entity, matrixStack, ticksExisted, rotY, partialTicks);
        ((AnimatedGeometryEntityModel)this.f_115290_).setTexture(this.getTextureTableLocation(entity, partialTicks));
        ((AnimatedGeometryEntityModel)this.f_115290_).setAnimations(this.getAnimations(entity, partialTicks));
        ((AnimatedGeometryEntityModel)this.f_115290_).setAnimationWeights(this.getAnimationWeights(entity, partialTicks));
        AnimationEffectHandler effectHandler = this.getEffectHandler(entity);
        if (effectHandler != null) {
            effectHandler.tick(this.getAnimations(entity), this.getBob(entity, partialTicks) / 20.0f);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return GeometryTextureManager.getAtlas().getAtlasLocation();
    }

    public ResourceLocation[] getAnimations(T entity, float partialTicks) {
        return this.getAnimations(entity);
    }

    public float[] getAnimationWeights(T entity, float partialTicks) {
        return this.getAnimationWeights(entity);
    }

    public ResourceLocation getTextureTableLocation(T entity, float partialTicks) {
        return this.getTextureTableLocation(entity);
    }

    @Deprecated
    public abstract ResourceLocation[] getAnimations(T var1);

    @Deprecated
    public abstract float[] getAnimationWeights(T var1);

    @Deprecated
    public abstract ResourceLocation getTextureTableLocation(T var1);
}

