/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.client.geometry.VanillaModelMapping;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class GeometryModelRenderer {
    private static final Map<Model, Map<String, ModelPart>> MODEL_PARTS = new HashMap<Model, Map<String, ModelPart>>();
    private static final Map<String, String> MAPPED_NAMES = new HashMap<String, String>();

    private GeometryModelRenderer() {
    }

    public static void copyModelAngles(@Nullable Model parent, GeometryModel model) {
        if (parent == null) {
            model.resetTransformation();
            return;
        }
        Map parentParts = MODEL_PARTS.computeIfAbsent(parent, GeometryModelRenderer::mapRenderers);
        for (String modelKey : model.getParentModelKeys()) {
            String name = MAPPED_NAMES.computeIfAbsent(modelKey, key -> VanillaModelMapping.get(parent.getClass(), key));
            if (!parentParts.containsKey(name)) continue;
            model.copyAngles("parent." + modelKey, (ModelPart)parentParts.get(name));
        }
    }

    public static void render(GeometryModel model, @Nullable ResourceLocation textureLocation, MultiBufferSource buffer, PoseStack matrixStack, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        GeometryModelRenderer.render(model, textureLocation, buffer, matrixStack, packedLight, packedOverlay, red, green, blue, alpha, null);
    }

    public static void render(GeometryModel model, @Nullable ResourceLocation textureLocation, MultiBufferSource buffer, PoseStack matrixStack, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, @Nullable Consumer<RenderType.CompositeState.CompositeStateBuilder> renderTypeConsumer) {
        if (GeometryTextureManager.isReloading()) {
            return;
        }
        GeometryModelTextureTable textures = textureLocation == null ? GeometryModelTextureTable.EMPTY : GeometryTextureManager.getTextures(textureLocation);
        for (String material : model.getMaterialKeys()) {
            GeometryModelTexture[] layers;
            for (GeometryModelTexture texture : layers = textures.getLayerTextures(material)) {
                model.render(material, texture, matrixStack, model.getBuffer(buffer, GeometryTextureManager.getAtlas(), texture, renderTypeConsumer), texture.isGlowing() ? 0xF000F0 : packedLight, packedOverlay, red * texture.getRed(), green * texture.getGreen(), blue * texture.getBlue(), alpha);
            }
        }
    }

    private static Map<String, ModelPart> mapRenderers(Model model) {
        HashMap<String, ModelPart> renderers = new HashMap<String, ModelPart>();
        for (Class<?> i = model.getClass(); i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field field : i.getDeclaredFields()) {
                if (field.isSynthetic() || !ModelPart.class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    renderers.put(field.getName(), (ModelPart)field.get(model));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return renderers;
    }
}

