/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererRegistry;
import gg.moonflower.pollen.pinwheel.core.client.DataContainerImpl;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public final class BlockRendererDispatcher {
    private static final Map<BlockGetter, DataContainerImpl> DATA_CONTAINERS = new WeakHashMap<BlockGetter, DataContainerImpl>(3);

    private BlockRendererDispatcher() {
    }

    public static void render(LevelReader level, PoseStack matrixStack, MultiBufferSource buffer, Camera camera, BlockState state, BlockPos pos, int packedLight, int packedOverlay, float partialTicks) {
        BlockRendererDispatcher.render(level, matrixStack, buffer, camera, BlockRendererRegistry.get(state.m_60734_()), pos, packedLight, packedOverlay, partialTicks);
    }

    public static void render(LevelReader level, PoseStack matrixStack, MultiBufferSource buffer, Camera camera, List<BlockRenderer> renderers, BlockPos pos, int packedLight, int packedOverlay, float partialTicks) {
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        for (BlockRenderer renderer : renderers) {
            matrixStack.m_85836_();
            renderer.render(level, pos, BlockRendererDispatcher.getDataContainer((BlockGetter)level, pos), buffer, matrixStack, camera, gameRenderer, gameRenderer.m_109154_(), packedLight, packedOverlay, partialTicks);
            matrixStack.m_85849_();
        }
    }

    public static boolean shouldRender(BlockState state) {
        BlockRenderer renderer = BlockRendererRegistry.getFirst(state.m_60734_());
        return renderer != null && renderer.getRenderShape(state) != RenderShape.MODEL;
    }

    public static BlockRenderer.DataContainer getDataContainer(BlockGetter level, BlockPos pos) {
        return DATA_CONTAINERS.computeIfAbsent(level, __ -> new DataContainerImpl(level)).get(pos);
    }
}

