/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.render;

import gg.moonflower.pollen.api.event.events.client.resource.ClientTagUpdateEvent;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.RenderExclusively;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockRendererRegistry {
    private static final RenderSet EMPTY = new RenderSet();
    private static final Map<Block, RenderSet> RENDERERS = new HashMap<Block, RenderSet>();
    private static final Map<TagKey<Block>, RenderSet> TAG_RENDERERS = new HashMap<TagKey<Block>, RenderSet>();
    private static final Lock RENDERERS_LOCK = new ReentrantLock();
    private static final Lock TAG_RENDERERS_LOCK = new ReentrantLock();
    private static final Map<Block, RenderSet> RENDERERS_CACHE = new ConcurrentHashMap<Block, RenderSet>();

    private static void addToSet(RenderSet renderers, BlockRenderer renderer) {
        RenderExclusively annotation = renderer.getClass().getDeclaredAnnotation(RenderExclusively.class);
        if (annotation != null && annotation.override()) {
            renderers.updateOverride(renderer, annotation);
        } else {
            renderers.addChild(renderer);
        }
    }

    public static void register(Block block, BlockRenderer renderer) {
        RENDERERS_LOCK.lock();
        RenderSet renderers = RENDERERS.computeIfAbsent(block, __ -> new RenderSet());
        RENDERERS_LOCK.unlock();
        BlockRendererRegistry.addToSet(renderers, renderer);
    }

    public static void register(TagKey<Block> tag, BlockRenderer renderer) {
        TAG_RENDERERS_LOCK.lock();
        RenderSet renderers = TAG_RENDERERS.computeIfAbsent(tag, __ -> new RenderSet());
        TAG_RENDERERS_LOCK.unlock();
        BlockRendererRegistry.addToSet(renderers, renderer);
    }

    public static List<BlockRenderer> get(Block block) {
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection == null) {
            RENDERERS_LOCK.lock();
            try {
                List<BlockRenderer> list = RENDERERS.getOrDefault(block, EMPTY).values();
                return list;
            }
            finally {
                RENDERERS_LOCK.unlock();
            }
        }
        if (RENDERERS_CACHE.containsKey(block)) {
            return RENDERERS_CACHE.get(block).values();
        }
        RenderSet set = null;
        RENDERERS_LOCK.lock();
        if (RENDERERS.containsKey(block)) {
            set = new RenderSet();
            RENDERERS.get(block).values().forEach(set::addChild);
        }
        RENDERERS_LOCK.unlock();
        TAG_RENDERERS_LOCK.lock();
        List tags = connection.m_105152_().m_175515_(Registry.f_122901_).m_203613_().toList();
        for (TagKey tag : tags) {
            if (!TAG_RENDERERS.containsKey(tag)) continue;
            if (set == null) {
                set = new RenderSet();
            }
            TAG_RENDERERS.get(tag).values().forEach(set::addChild);
        }
        TAG_RENDERERS_LOCK.unlock();
        if (set == null) {
            set = EMPTY;
        }
        RENDERERS_CACHE.put(block, set);
        return set.values();
    }

    @Nullable
    public static BlockRenderer getFirst(Block block) {
        List<BlockRenderer> renderers = BlockRendererRegistry.get(block);
        return !renderers.isEmpty() ? renderers.get(0) : null;
    }

    static {
        ClientTagUpdateEvent.EVENT.register(RENDERERS_CACHE::clear);
    }

    private static class RenderSet {
        private volatile BlockRenderer override = null;
        private final Set<BlockRenderer> children = ConcurrentHashMap.newKeySet();
        private volatile List<BlockRenderer> cache = Collections.emptyList();

        private RenderSet() {
        }

        private synchronized void updateOverride(BlockRenderer renderer, RenderExclusively annotation) {
            if (this.override == null || annotation.priority() < RenderSet.getPriority(this.override)) {
                this.override = renderer;
                this.cache = null;
            }
        }

        private void addChild(BlockRenderer renderer) {
            this.children.add(renderer);
            this.cache = null;
        }

        private List<BlockRenderer> values() {
            if (this.cache == null) {
                this.cache = new ArrayList<BlockRenderer>(this.children);
                this.cache.sort(Comparator.comparingInt(RenderSet::getPriority));
                if (this.override != null) {
                    this.cache.add(0, this.override);
                }
            }
            return this.cache;
        }

        private static int getPriority(BlockRenderer renderer) {
            RenderExclusively annotation = renderer.getClass().getDeclaredAnnotation(RenderExclusively.class);
            return annotation != null ? annotation.priority() : 1000;
        }
    }
}

