/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client;

import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.pinwheel.api.client.blockdata.BlockData;
import gg.moonflower.pollen.pinwheel.api.client.blockdata.BlockDataKey;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BlockDataStorage {
    private static final Map<BlockGetter, BlockDataStorage> DATA = new WeakHashMap<BlockGetter, BlockDataStorage>(3);
    private final BlockGetter level;
    private final Map<BlockPos, Map<BlockDataKey<?>, BlockData<?>>> data;

    private BlockDataStorage(BlockGetter level) {
        this.level = level;
        this.data = new HashMap();
    }

    public <T> BlockData<T> get(BlockDataKey<T> key, BlockPos pos) {
        BlockState state = this.level.m_8055_(pos);
        Map map = this.data.computeIfAbsent(pos.m_7949_(), __ -> new HashMap());
        if (map.containsKey(key) && !key.getFilter().test(state)) {
            map.remove(key);
        }
        return map.computeIfAbsent(key, BlockDataImpl::new);
    }

    public void invalidateChunk(ChunkPos chunkPos) {
        this.data.keySet().removeIf(pos -> pos.m_123341_() >= chunkPos.m_45604_() && pos.m_123341_() < chunkPos.m_45608_() && pos.m_123343_() >= chunkPos.m_45605_() && pos.m_123343_() < chunkPos.m_45609_());
    }

    public static BlockDataStorage get(BlockGetter level) {
        return DATA.computeIfAbsent(level, BlockDataStorage::new);
    }

    public void update(BlockState state, BlockPos pos) {
        if (!this.data.containsKey(pos)) {
            return;
        }
        Map<BlockDataKey<?>, BlockData<?>> map = this.data.get(pos);
        map.keySet().removeIf(key -> !key.getFilter().test(state));
    }

    static {
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> DATA.clear());
    }

    private static class BlockDataImpl<T>
    implements BlockData<T> {
        private final Supplier<T> defaultValue;
        private T value;

        private BlockDataImpl(BlockDataKey<T> key) {
            this.defaultValue = key.getDefault();
            this.value = key.getDefault().get();
        }

        @Override
        public void set(@Nullable T value) {
            this.value = value != null ? value : this.defaultValue.get();
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

