/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.texture;

import com.google.gson.Gson;
import gg.moonflower.pollen.pinwheel.api.client.texture.TextureTableLoader;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelParser;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LocalTextureTableLoader
implements TextureTableLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private final Map<ResourceLocation, GeometryModelTextureTable> textures = new HashMap<ResourceLocation, GeometryModelTextureTable>();
    private final String folder;
    private String[] hashTables;

    public LocalTextureTableLoader() {
        this("textures/geometry");
    }

    public LocalTextureTableLoader(@Nullable String folder) {
        this.folder = folder == null || folder.isEmpty() ? "" : folder + "/";
        this.hashTables = new String[0];
    }

    @Override
    public void addTextures(BiConsumer<ResourceLocation, GeometryModelTextureTable> textureConsumer) {
        this.textures.forEach(textureConsumer);
    }

    @Override
    public void addHashTables(Consumer<String> hashTableConsumer) {
        for (String hashTable : this.hashTables) {
            hashTableConsumer.accept(hashTable);
        }
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, GeometryModelTextureTable> textureLocations = new HashMap<ResourceLocation, GeometryModelTextureTable>();
            for (ResourceLocation textureTableLocation : resourceManager.m_6540_(this.folder, name -> name.endsWith(".json"))) {
                ResourceLocation textureTableName = new ResourceLocation(textureTableLocation.m_135827_(), textureTableLocation.m_135815_().substring(this.folder.length(), textureTableLocation.m_135815_().length() - 5));
                if (textureTableName.m_135815_().equals("hash_tables")) continue;
                try {
                    Resource resource = resourceManager.m_142591_(textureTableLocation);
                    try {
                        GeometryModelTextureTable table = GeometryModelParser.parseTextures(new InputStreamReader(resource.m_6679_()));
                        table.getTextureDefinitions().forEach((name, textures) -> {
                            for (GeometryModelTexture texture : textures) {
                                if (texture.getType() != GeometryModelTexture.Type.ONLINE) continue;
                                throw new IllegalArgumentException(name + " uses unsupported texture type: " + texture.getType().name().toLowerCase());
                            }
                        });
                        textureLocations.put(textureTableName, table);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load texture table '" + textureTableName + "'", (Throwable)e);
                }
            }
            LOGGER.info("Loaded " + textureLocations.size() + " model texture tables.");
            return textureLocations;
        }, backgroundExecutor).thenAcceptBothAsync(CompletableFuture.supplyAsync(() -> {
            HashSet<String> hashTables = new HashSet<String>();
            for (String domain : resourceManager.m_7187_()) {
                ResourceLocation hashTableLocation = new ResourceLocation(domain, this.folder + "hash_tables.json");
                if (!resourceManager.m_7165_(hashTableLocation)) continue;
                try {
                    Resource resource = resourceManager.m_142591_(hashTableLocation);
                    try {
                        hashTables.addAll(Arrays.asList((String[])GSON.fromJson((Reader)new InputStreamReader(resource.m_6679_()), String[].class)));
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load texture hash table for " + domain, (Throwable)e);
                }
            }
            LOGGER.info("Loaded " + hashTables.size() + " hash tables.");
            return hashTables.toArray(new String[0]);
        }, backgroundExecutor), (textureLocations, hashTables) -> {
            this.textures.clear();
            this.textures.putAll((Map<ResourceLocation, GeometryModelTextureTable>)textureLocations);
            this.hashTables = hashTables;
        }, gameExecutor)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
    }
}

