/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.common.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.math.Vector3f;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.core.common.geometry.Geometry110Parser;
import gg.moonflower.pollen.pinwheel.core.common.geometry.Geometry180Parser;
import java.util.HashSet;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Geometry1120Parser {
    private Geometry1120Parser() {
    }

    public static GeometryModelData[] parseModel(JsonElement json) throws JsonParseException {
        JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"minecraft:geometry");
        GeometryModelData[] data = new GeometryModelData[jsonArray.size()];
        for (int i = 0; i < data.length; ++i) {
            GeometryModelData.Bone[] bones;
            JsonObject object = GsonHelper.m_13918_((JsonElement)jsonArray.get(i), (String)("minecraft:geometry[" + i + "]"));
            GeometryModelData.Description description = Geometry1120Parser.parseDescription(GsonHelper.m_13930_((JsonObject)object, (String)"description"));
            if (object.has("bones")) {
                HashSet<String> usedNames = new HashSet<String>();
                JsonArray bonesJson = GsonHelper.m_13933_((JsonObject)object, (String)"bones");
                bones = new GeometryModelData.Bone[bonesJson.size()];
                for (int j = 0; j < bones.length; ++j) {
                    bones[j] = Geometry1120Parser.parseBone(GsonHelper.m_13918_((JsonElement)bonesJson.get(j), (String)("bones[" + j + "]")));
                    if (usedNames.add(bones[j].getName())) continue;
                    throw new JsonSyntaxException("Duplicate bone: " + bones[j].getName());
                }
            } else {
                bones = new GeometryModelData.Bone[]{};
            }
            data[i] = new GeometryModelData(description, bones);
        }
        return data;
    }

    private static GeometryModelData.Description parseDescription(JsonObject json) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String identifier = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"identifier");
        float visibleBoundsWidth = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"visible_bounds_width", (float)0.0f);
        float visibleBoundsHeight = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"visible_bounds_height", (float)0.0f);
        float[] visibleBoundsOffset = JSONTupleParser.getFloat(jsonObject, "visible_bounds_offset", 3, () -> new float[3]);
        int textureWidth = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"texture_width", (int)256);
        int textureHeight = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"texture_height", (int)256);
        boolean preserveModelPose2588 = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"preserve_model_pose2588", (boolean)false);
        if (textureWidth == 0) {
            throw new JsonSyntaxException("Texture width must not be zero");
        }
        if (textureHeight == 0) {
            throw new JsonSyntaxException("Texture height must not be zero");
        }
        return new GeometryModelData.Description(identifier, visibleBoundsWidth, visibleBoundsHeight, new Vector3f(visibleBoundsOffset[0], visibleBoundsOffset[1], visibleBoundsOffset[2]), textureWidth, textureHeight, preserveModelPose2588);
    }

    private static GeometryModelData.Bone parseBone(JsonObject json) throws JsonParseException {
        JsonObject boneJson = json.getAsJsonObject();
        String name = GsonHelper.m_13906_((JsonObject)boneJson, (String)"name");
        boolean reset2588 = GsonHelper.m_13855_((JsonObject)boneJson, (String)"reset2588", (boolean)false);
        boolean neverRender2588 = GsonHelper.m_13855_((JsonObject)boneJson, (String)"neverrender2588", (boolean)false);
        String parent = GsonHelper.m_13851_((JsonObject)boneJson, (String)"parent", null);
        float[] pivot = JSONTupleParser.getFloat(boneJson, "pivot", 3, () -> new float[3]);
        float[] rotation = JSONTupleParser.getFloat(boneJson, "rotation", 3, () -> new float[3]);
        float[] bindPoseRotation2588 = JSONTupleParser.getFloat(boneJson, "bind_pose_rotation2588", 3, () -> new float[3]);
        boolean mirror = GsonHelper.m_13855_((JsonObject)boneJson, (String)"mirror", (boolean)false);
        float inflate = GsonHelper.m_13820_((JsonObject)boneJson, (String)"inflate", (float)0.0f);
        boolean debug = GsonHelper.m_13855_((JsonObject)boneJson, (String)"debug", (boolean)false);
        GeometryModelData.Cube[] cubes = json.has("cubes") ? Geometry180Parser.parseCubes(json) : new GeometryModelData.Cube[]{};
        GeometryModelData.Locator[] locators = json.has("locators") ? Geometry110Parser.parseLocators(json) : new GeometryModelData.Locator[]{};
        GeometryModelData.PolyMesh polyMesh = boneJson.has("poly_mesh") ? (GeometryModelData.PolyMesh)Geometry180Parser.GSON.fromJson(boneJson.get("poly_mesh"), GeometryModelData.PolyMesh.class) : null;
        return new GeometryModelData.Bone(name, reset2588, neverRender2588, parent, new Vector3f(pivot[0], pivot[1], pivot[2]), new Vector3f(rotation[0], rotation[1], rotation[2]), new Vector3f(bindPoseRotation2588[0], bindPoseRotation2588[1], bindPoseRotation2588[2]), mirror, inflate, debug, cubes, locators, polyMesh);
    }
}

