/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client;

import net.bettercombat.BetterCombat;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.PlayerAttackAnimatable;
import net.bettercombat.config.ServerConfig;
import net.bettercombat.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.network.Packets;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ClientNetwork {
    public static void initializeHandlers() {
        ClientPlayNetworking.registerGlobalReceiver(Packets.AttackAnimation.ID, (client, handler, buf, responseSender) -> {
            Packets.AttackAnimation packet = Packets.AttackAnimation.read(buf);
            client.execute(() -> {
                Entity entity = client.f_91073_.m_6815_(packet.playerId());
                if (entity instanceof Player) {
                    if (packet.animationName().equals(Packets.AttackAnimation.StopSymbol)) {
                        ((PlayerAttackAnimatable)entity).stopAttackAnimation();
                    } else {
                        ((PlayerAttackAnimatable)entity).playAttackAnimation(packet.animationName(), packet.isOffHand(), packet.length());
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.AttackSound.ID, (client, handler, buf, responseSender) -> {
            Packets.AttackSound packet = Packets.AttackSound.read(buf);
            client.execute(() -> {
                try {
                    if (BetterCombatClient.config.weaponSwingSoundVolume == 0) {
                        return;
                    }
                    SoundEvent soundEvent = (SoundEvent)Registry.f_122821_.m_7745_(new ResourceLocation(packet.soundId()));
                    int configVolume = BetterCombatClient.config.weaponSwingSoundVolume;
                    float volume = packet.volume() * ((float)Math.min(Math.max(configVolume, 0), 100) / 100.0f);
                    client.f_91073_.m_7785_(packet.x(), packet.y(), packet.z(), soundEvent, SoundSource.PLAYERS, volume, packet.pitch(), true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(Packets.WeaponRegistrySync.ID, (client, handler, buf, responseSender) -> WeaponRegistry.decodeRegistry(buf));
        ClientPlayNetworking.registerGlobalReceiver(Packets.ConfigSync.ID, (client, handler, buf, responseSender) -> {
            ServerConfig config;
            BetterCombat.config = config = Packets.ConfigSync.read(buf);
            BetterCombatClient.ENABLED = true;
        });
    }
}

