/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import java.util.Arrays;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.ComboState;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;

public class PlayerAttackHelper {
    public static float getDualWieldingAttackDamageMultiplier(Player player, AttackHand hand) {
        return PlayerAttackHelper.isDualWielding(player) ? (hand.isOffHand() ? BetterCombat.config.dual_wielding_off_hand_damage_multiplier : BetterCombat.config.dual_wielding_main_hand_damage_multiplier) : 1.0f;
    }

    public static boolean shouldAttackWithOffHand(Player player, int comboCount) {
        return PlayerAttackHelper.isDualWielding(player) && comboCount % 2 == 1;
    }

    public static boolean isDualWielding(Player player) {
        WeaponAttributes mainAttributes = WeaponRegistry.getAttributes(player.m_21205_());
        WeaponAttributes offAttributes = WeaponRegistry.getAttributes(player.m_21206_());
        return mainAttributes != null && !mainAttributes.isTwoHanded() && offAttributes != null && !offAttributes.isTwoHanded();
    }

    public static boolean isTwoHandedWielding(Player player) {
        WeaponAttributes mainAttributes = WeaponRegistry.getAttributes(player.m_21205_());
        if (mainAttributes != null) {
            return mainAttributes.isTwoHanded();
        }
        return false;
    }

    public static AttackHand getCurrentAttack(Player player, int comboCount) {
        if (PlayerAttackHelper.isDualWielding(player)) {
            boolean isOffHand = PlayerAttackHelper.shouldAttackWithOffHand(player, comboCount);
            ItemStack itemStack = isOffHand ? player.m_21206_() : player.m_21205_();
            WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
            int handSpecificComboCount = (isOffHand && comboCount > 0 ? comboCount - 1 : comboCount) / 2;
            AttackSelection attackSelection = PlayerAttackHelper.selectAttack(handSpecificComboCount, attributes, player, isOffHand);
            WeaponAttributes.Attack attack = attackSelection.attack;
            ComboState combo = attackSelection.comboState;
            return new AttackHand(attack, combo, isOffHand, attributes, itemStack);
        }
        ItemStack itemStack = player.m_21205_();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
        if (attributes != null) {
            AttackSelection attackSelection = PlayerAttackHelper.selectAttack(comboCount, attributes, player, false);
            WeaponAttributes.Attack attack = attackSelection.attack;
            ComboState combo = attackSelection.comboState;
            return new AttackHand(attack, combo, false, attributes, itemStack);
        }
        return null;
    }

    private static AttackSelection selectAttack(int comboCount, WeaponAttributes attributes, Player player, boolean isOffHandAttack) {
        WeaponAttributes.Attack[] attacks = attributes.attacks();
        attacks = (WeaponAttributes.Attack[])Arrays.stream(attacks).filter(attack -> attack.conditions() == null || attack.conditions().length == 0 || PlayerAttackHelper.evaluateConditions(attack.conditions(), player, isOffHandAttack)).toArray(WeaponAttributes.Attack[]::new);
        if (comboCount < 0) {
            comboCount = 0;
        }
        int index = comboCount % attacks.length;
        return new AttackSelection(attacks[index], new ComboState(index + 1, attacks.length));
    }

    private static boolean evaluateConditions(WeaponAttributes.Condition[] conditions, Player player, boolean isOffHandAttack) {
        return Arrays.stream(conditions).allMatch(condition -> PlayerAttackHelper.evaluateCondition(condition, player, isOffHandAttack));
    }

    private static boolean evaluateCondition(WeaponAttributes.Condition condition, Player player, boolean isOffHandAttack) {
        if (condition == null) {
            return true;
        }
        switch (condition) {
            case NOT_DUAL_WIELDING: {
                return !PlayerAttackHelper.isDualWielding(player);
            }
            case DUAL_WIELDING_ANY: {
                return PlayerAttackHelper.isDualWielding(player);
            }
            case DUAL_WIELDING_SAME: {
                return PlayerAttackHelper.isDualWielding(player) && player.m_21205_().m_41720_() == player.m_21206_().m_41720_();
            }
            case DUAL_WIELDING_SAME_CATEGORY: {
                if (!PlayerAttackHelper.isDualWielding(player)) {
                    return false;
                }
                WeaponAttributes mainHandAttributes = WeaponRegistry.getAttributes(player.m_21205_());
                WeaponAttributes offHandAttributes = WeaponRegistry.getAttributes(player.m_21206_());
                if (mainHandAttributes.category() == null || mainHandAttributes.category().isEmpty() || offHandAttributes.category() == null || offHandAttributes.category().isEmpty()) {
                    return false;
                }
                return mainHandAttributes.category().equals(offHandAttributes.category());
            }
            case NO_OFFHAND_ITEM: {
                ItemStack offhandStack = player.m_21206_();
                return offhandStack == null || offhandStack.m_41619_();
            }
            case OFF_HAND_SHIELD: {
                ItemStack offhandStack = player.m_21206_();
                return offhandStack != null || offhandStack.m_41720_() instanceof ShieldItem;
            }
            case MAIN_HAND_ONLY: {
                return !isOffHandAttack;
            }
            case OFF_HAND_ONLY: {
                return isOffHandAttack;
            }
        }
        return true;
    }

    public static void setAttributesForOffHandAttack(Player player, boolean useOffHand) {
        ItemStack add;
        ItemStack remove;
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        if (useOffHand) {
            remove = mainHandStack;
            add = offHandStack;
        } else {
            remove = offHandStack;
            add = mainHandStack;
        }
        if (remove != null) {
            player.m_21204_().m_22161_(remove.m_41638_(EquipmentSlot.MAINHAND));
        }
        if (add != null) {
            player.m_21204_().m_22178_(add.m_41638_(EquipmentSlot.MAINHAND));
        }
    }

    private record AttackSelection(WeaponAttributes.Attack attack, ComboState comboState) {
    }
}

