/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import net.bettercombat.BetterCombat;
import net.bettercombat.config.ServerConfig;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;

public class TargetHelper {
    public static Relation getRelation(Player attacker, Entity target) {
        OwnableEntity tameable;
        Entity owner;
        if (attacker == target) {
            return Relation.FRIENDLY;
        }
        if (target instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)target).m_142480_()) != null) {
            return TargetHelper.getRelation(attacker, owner);
        }
        ServerConfig config = BetterCombat.config;
        Team casterTeam = attacker.m_5647_();
        Team targetTeam = target.m_5647_();
        if (casterTeam == null || targetTeam == null) {
            if (target instanceof Player) {
                return Relation.coalesce(config.player_relation_to_teamless_players, Relation.NEUTRAL);
            }
            if (target instanceof Villager) {
                return Relation.coalesce(config.player_relation_to_villagers, Relation.NEUTRAL);
            }
            if (target instanceof AgeableMob) {
                return Relation.coalesce(config.player_relation_to_passives, Relation.HOSTILE);
            }
            if (target instanceof Monster) {
                return Relation.coalesce(config.player_relation_to_hostiles, Relation.HOSTILE);
            }
            return Relation.coalesce(config.player_relation_to_other, Relation.HOSTILE);
        }
        return attacker.m_7307_(target) ? Relation.FRIENDLY : Relation.HOSTILE;
    }

    public static enum Relation {
        FRIENDLY,
        NEUTRAL,
        HOSTILE;


        public static Relation coalesce(Relation value, Relation fallback) {
            if (value != null) {
                return value;
            }
            return fallback;
        }
    }
}

